package com.xebialabs.deployit.plugin.osb.ci;

import java.util.ArrayList;
import java.util.List;

import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ConfigurationItemProperty.Size;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;

@SuppressWarnings("serial")
@ConfigurationItem(description ="Oracle Service Bus Domain")
public class OsbDomain extends WlsDomain {
	
	@ConfigurationItemProperty(required = true, description = "The location of the Oracle Service Bus.", size = Size.LARGE)
	private String osbHome;

	public String getOsbHome() {
		return osbHome;
	}

	public void setOsbHome(String osbHome) {
		this.osbHome = osbHome;
	}
	
	@Override
	public int executeWlstJythonScript(CommandExecutionCallbackHandler handler, HostSession s, String scriptPath,
			String... args) {
		final String filesep = getActiveHost().getOperatingSystemFamily().getFileSeparator();
		final String pathsep = getActiveHost().getOperatingSystemFamily().getPathSeparator();
		
		final String wlstFilePath = getWlJavaHome() + filesep + "bin" + filesep + "java";
		final String weblogicJarFilePath = getWlHome() + filesep + "server" + filesep + "lib" + filesep + "weblogic.jar";
		
		
		StringBuffer classPath = new StringBuffer();
		final String pathSeparator = getActiveHost().getPathSeparator();
		classPath.append(weblogicJarFilePath).append(pathSeparator);
		classPath.append(getOsbHome() + filesep + "lib" + filesep + "sb-kernel-api.jar" + pathsep);
		classPath.append(getOsbHome() + filesep + ".." + filesep + "modules" + filesep
				+ "com.bea.common.configfwk_1.1.0.0.jar" + pathsep);

		
		List<String> cmd = new ArrayList<String>();
		cmd.add(wlstFilePath);
		cmd.add("-classpath");
		cmd.add(classPath.toString());
		cmd.add("weblogic.WLST");
		cmd.add("-i");
		cmd.add(scriptPath);
		for (String arg : args) {
			cmd.add(arg);
		}
		String[] cmdArray = (String[]) cmd.toArray(new String[cmd.size()]);

		return s.execute(handler, cmdArray);
	}

}
