package com.xebialabs.deployit.maven.helper;

import com.google.common.base.Joiner;

import static com.google.common.base.Preconditions.checkNotNull;
import static com.google.common.base.Strings.emptyToNull;

public final class IdHelper {

    private IdHelper() {
    }

    public static String generateId(String groupId, String artifactId, String classifier, String type){
        checkNotNull(artifactId);
        return Joiner.on(":").skipNulls().join(groupId, emptyToNull(classifier), artifactId, emptyToNull(type));
    }

    public static String generateId(String groupId, String artifactId){
        return generateId(groupId, artifactId, null, null);
    }
}
