/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.maven.helper;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.DiscreteDomains;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ranges;
import com.xebialabs.deployit.booter.remote.DeployitCommunicator;
import com.xebialabs.deployit.booter.remote.Proxies;
import com.xebialabs.deployit.booter.remote.client.DeployitRemoteClient;
import com.xebialabs.deployit.engine.api.RepositoryService;
import com.xebialabs.deployit.engine.api.TaskService;
import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.engine.api.dto.ValidatedConfigurationItem;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.api.execution.TaskState;
import com.xebialabs.deployit.maven.MavenDeployed;
import com.xebialabs.deployit.maven.helper.DeploymentLogger;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;

public class DeploymentHelper {
    public static final HashSet<TaskExecutionState> TERMINAL_STATES = new HashSet<TaskExecutionState>(){
        {
            this.add(TaskExecutionState.DONE);
            this.add(TaskExecutionState.EXECUTED);
            this.add(TaskExecutionState.STOPPED);
            this.add(TaskExecutionState.CANCELLED);
        }
    };
    private DeploymentLogger log;
    private Proxies proxies;
    private DeployitCommunicator communicator;
    public static final int TASK_WAIT_TIMEOUT_MS = 1000;

    public DeploymentHelper(DeploymentLogger log, DeployitCommunicator communicator) {
        this.log = log;
        this.proxies = communicator.getProxies();
        this.communicator = communicator;
    }

    public boolean isApplicationDeployed(String source, String target) {
        ArrayList splitSource = Lists.newArrayList((Iterable)Splitter.on((String)"/").split((CharSequence)source));
        String appName = (String)splitSource.get(splitSource.size() - 2);
        String deployedPath = Joiner.on((String)"/").join((Object)target, (Object)appName, new Object[0]);
        return this.proxies.getRepositoryService().exists(deployedPath);
    }

    public Deployment attachExplicitDeployeds(Deployment deployment, List<MavenDeployed> explicits) {
        this.log.debug("use explicits deployeds");
        for (MavenDeployed configuredDeployed : explicits) {
            Preconditions.checkNotNull((Object)configuredDeployed.getId(), (Object)"id is mandatory in the explicit deployed mode");
            String type = configuredDeployed.getType();
            Preconditions.checkNotNull((Object)type, (Object)"type is mandatory in the explicit deployed mode");
            final String deployableId = configuredDeployed.getDeployable(deployment.getVersion());
            final String containerId = configuredDeployed.getContainer();
            boolean exist = Iterables.any((Iterable)deployment.getDeployeds(), (Predicate)new Predicate<ConfigurationItem>(){

                public boolean apply(ConfigurationItem input) {
                    return input.getProperty("deployable").equals(deployableId) && input.getProperty("container").equals(containerId);
                }
            });
            if (exist) {
                this.log.debug(String.format(" deployed  %s %s %s already exists", deployableId, containerId, type));
                continue;
            }
            this.log.debug(String.format(" generateSingleDeployed %s %s %s", deployableId, containerId, type));
            deployment = this.proxies.getDeploymentService().generateSingleDeployed(deployableId, containerId, Type.valueOf((String)configuredDeployed.getType()), deployment);
        }
        return deployment;
    }

    public void skipAllSteps(String taskId) {
        TaskService taskService = this.proxies.getTaskService();
        taskService.skip(taskId, (List)Lists.newArrayList((Iterable)Ranges.open((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(taskService.getTask(taskId).getNrSteps() + 1)).asSet(DiscreteDomains.integers())));
    }

    public TaskExecutionState executeAndArchiveTask(String taskId) {
        TaskService taskService = this.proxies.getTaskService();
        this.log.info("-----------------------");
        this.log.info("Task execution plan: ");
        this.log.info("-----------------------");
        this.logTaskState(taskId);
        this.log.info("-----------------------");
        this.log.info("Task execution progress: ");
        this.log.info("-----------------------");
        taskService.start(taskId);
        TaskState taskState = taskService.getTask(taskId);
        int lastLoggedStep = -1;
        while (!TERMINAL_STATES.contains(taskState.getState())) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.log.debug("Waiting for task to be done...");
            taskState = taskService.getTask(taskId);
            if (taskState.getCurrentStepNr() <= lastLoggedStep) continue;
            this.logStepState(taskId, taskState.getCurrentStepNr());
            lastLoggedStep = taskState.getCurrentStepNr();
        }
        this.log.info("-----------------------");
        this.log.info("Task execution result: ");
        this.log.info("-----------------------");
        this.logTaskState(taskId);
        taskService.archive(taskId);
        return taskState.getState();
    }

    public void logTaskState(String taskId) {
        TaskState taskState = this.proxies.getTaskService().getTask(taskId);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd hh:mm:ss");
        this.log.info(String.format("%s Description    %s", taskId, taskState.getDescription()));
        this.log.info(String.format("%s State          %s %d/%d", taskId, taskState.getState(), taskState.getCurrentStepNr(), taskState.getNrSteps()));
        if (taskState.getStartDate() != null) {
            GregorianCalendar startDate = taskState.getStartDate().toGregorianCalendar();
            this.log.info(String.format("%s Start      %s", taskId, sdf.format(startDate.getTime())));
        }
        if (taskState.getCompletionDate() != null) {
            GregorianCalendar completionDate = taskState.getCompletionDate().toGregorianCalendar();
            this.log.info(String.format("%s Completion %s", taskId, sdf.format(completionDate.getTime())));
        }
        for (int i = 1; i <= taskState.getNrSteps(); ++i) {
            this.logStepState(taskId, i);
        }
        if (TaskExecutionState.STOPPED.equals((Object)taskState.getState())) {
            throw new IllegalStateException(String.format("Errors when executing task %s", taskId));
        }
    }

    public void logStepState(String taskId, int stepNumber) {
        StepState stepInfo = this.proxies.getTaskService().getStep(taskId, stepNumber, null);
        String description = stepInfo.getDescription();
        String stepInfoMessage = stepInfo.getLog() == null || stepInfo.getLog().isEmpty() || description.equals(stepInfo.getLog()) ? String.format("%s step #%d %s\t%s", taskId, stepNumber, stepInfo.getState(), description) : String.format("%s step #%d %s\t%s\n%s", taskId, stepNumber, stepInfo.getState(), description, stepInfo.getLog());
        this.log.info(stepInfoMessage);
    }

    public Deployment validateDeployment(Deployment deployment) throws DeploymentValidationError {
        ArrayList validationMessages = Lists.newArrayList();
        Deployment validatedDeployment = this.proxies.getDeploymentService().validate(deployment);
        for (ConfigurationItem configurationItem : validatedDeployment.getDeployeds()) {
            if (!(configurationItem instanceof ValidatedConfigurationItem)) continue;
            for (ValidationMessage msg : ((ValidatedConfigurationItem)configurationItem).getValidations()) {
                validationMessages.add(msg);
            }
        }
        if (!validationMessages.isEmpty()) {
            throw new DeploymentValidationError(validationMessages);
        }
        return validatedDeployment;
    }

    public ConfigurationItem readCiOrNull(String environmentId) {
        this.log.debug("reading the environment " + environmentId);
        RepositoryService repositoryService = this.proxies.getRepositoryService();
        if (repositoryService.exists(environmentId).booleanValue()) {
            return repositoryService.read(environmentId);
        }
        return null;
    }

    public void logEnvironment(ConfigurationItem envCi) {
        if (envCi != null) {
            this.log.debug(" dumping members of " + envCi.getId());
            List members = (List)envCi.getProperty("members");
            for (String container : members) {
                this.log.debug(String.format(" Member: %s ", container));
            }
        }
    }

    public ConfigurationItem createEnvironment(String id, List<? extends ConfigurationItem> members) throws EnvironmentAlreadyExistsError {
        RepositoryService repositoryService = this.proxies.getRepositoryService();
        if (repositoryService.exists(id).booleanValue()) {
            throw new EnvironmentAlreadyExistsError(id);
        }
        for (ConfigurationItem configurationItem : members) {
            repositoryService.create(configurationItem.getId(), configurationItem);
        }
        BaseConfigurationItem env = new BaseConfigurationItem();
        env.setType(Type.valueOf((String)"udm.Environment"));
        env.setId(id);
        List list = Lists.transform(members, (Function)new Function<ConfigurationItem, Object>(){

            public Object apply(ConfigurationItem input) {
                return input.getId();
            }
        });
        env.setProperty("members", (Object)list);
        return repositoryService.create(id, (ConfigurationItem)env);
    }

    public ConfigurationItem uploadPackage(File darFile) {
        this.log.info("Importing dar file " + darFile.getAbsolutePath());
        return new DeployitRemoteClient(this.communicator).importPackage(darFile.getAbsolutePath());
    }

    public static class EnvironmentAlreadyExistsError
    extends Exception {
        public EnvironmentAlreadyExistsError(String envId) {
            super(String.format("Can not create environment [%s] because it already exists.", envId));
        }
    }

    public static class DeploymentValidationError
    extends Exception {
        private List<ValidationMessage> validationMessages = Lists.newArrayList();

        public DeploymentValidationError(List<ValidationMessage> validationMessages) {
            super("Deployment contains " + validationMessages.size() + " validation messages");
            this.validationMessages = validationMessages;
        }

        public List<ValidationMessage> getValidationMessages() {
            return this.validationMessages;
        }
    }
}

