/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.maven.converter;

import com.google.common.collect.ImmutableSet;
import com.xebialabs.deployit.maven.Container;
import com.xebialabs.deployit.maven.Deployable;
import com.xebialabs.deployit.maven.Deployed;
import com.xebialabs.deployit.maven.MavenContainer;
import com.xebialabs.deployit.maven.MavenDeployable;
import com.xebialabs.deployit.maven.MavenDeployed;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.AbstractConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;

public class DeployitCIConverter
extends AbstractConfigurationConverter {
    public static final String MAVEN_EXPRESSION_EVALUATOR_ID = "maven.expressionEvaluator";
    public static final String ROLE = ConfigurationConverter.class.getName();
    private static final String ADD_TO_ENV = "addToEnv";
    static final Set<Class<?>> SUPPORTED_TYPES = ImmutableSet.of(MavenContainer.class, MavenDeployable.class, MavenDeployed.class, Deployed.class, Deployable.class, Container.class, (Object[])new Class[0]);

    public boolean canConvert(Class type) {
        return SUPPORTED_TYPES.contains(type);
    }

    public Object fromConfiguration(ConverterLookup converterLookup, PlexusConfiguration configuration, Class type, Class baseType, ClassLoader classLoader, ExpressionEvaluator expressionEvaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        if (type.equals(MavenContainer.class) || type.equals(Container.class)) {
            return this.convertToContainer(configuration);
        }
        if (type.equals(MavenDeployable.class) || type.equals(Deployable.class)) {
            return this.convertToDeployable(configuration);
        }
        if (type.equals(MavenDeployed.class) || type.equals(Deployed.class)) {
            return this.convertToDeployed(configuration);
        }
        throw new ComponentConfigurationException("type not handled (" + type + ")");
    }

    private MavenContainer convertToContainer(PlexusConfiguration configuration) throws ComponentConfigurationException {
        MavenContainer container = new MavenContainer();
        try {
            Map<String, Object> properties = this.doConvertToProperties(configuration);
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                container.addParameter(entry.getKey(), entry.getValue());
            }
            String add2Env = configuration.getAttribute(ADD_TO_ENV);
            if (add2Env != null) {
                container.setAddedToEnvironment(Boolean.parseBoolean(add2Env));
            }
        }
        catch (Exception e) {
            throw new ComponentConfigurationException((Throwable)e);
        }
        return container;
    }

    private Map<String, Object> doConvertToProperties(PlexusConfiguration configuration) throws PlexusConfigurationException, ComponentConfigurationException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (PlexusConfiguration propertyConfiguration : configuration.getChildren()) {
            String name = propertyConfiguration.getName();
            if (propertyConfiguration.getChild("list", false) != null) {
                PlexusConfiguration[] values = propertyConfiguration.getChild("list").getChildren();
                ArrayList<String> list = new ArrayList<String>();
                for (PlexusConfiguration valueConfiguration : values) {
                    list.add(valueConfiguration.getValue());
                }
                properties.put(name, list);
                continue;
            }
            if (propertyConfiguration.getChild("map", false) != null) {
                PlexusConfiguration[] entries = propertyConfiguration.getChild("map").getChildren();
                HashMap<String, String> map = new HashMap<String, String>();
                for (PlexusConfiguration entryConfiguration : entries) {
                    map.put(entryConfiguration.getName(), entryConfiguration.getValue());
                }
                properties.put(name, map);
                continue;
            }
            if (name.equals("placeholders")) {
                properties.put(name, this.convertOldPlaceholderFormat(propertyConfiguration));
                continue;
            }
            properties.put(name, propertyConfiguration.getValue());
        }
        return properties;
    }

    private Map<String, String> convertOldPlaceholderFormat(PlexusConfiguration configuration) throws ComponentConfigurationException {
        HashMap<String, String> map = new HashMap<String, String>();
        for (PlexusConfiguration entry : configuration.getChildren()) {
            PlexusConfiguration k = entry.getChild("k");
            PlexusConfiguration v = entry.getChild("v");
            map.put(k.getValue(), v.getValue());
        }
        return map;
    }

    private MavenDeployed convertToDeployed(PlexusConfiguration configuration) throws ComponentConfigurationException {
        try {
            MavenDeployed deployed = new MavenDeployed();
            Map<String, Object> properties = this.doConvertToProperties(configuration);
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                if (entry.getKey().equals("placeholders")) {
                    deployed.getPlaceholders().putAll((Map)entry.getValue());
                    continue;
                }
                deployed.addValues(entry.getKey(), entry.getValue());
            }
            return deployed;
        }
        catch (Exception e) {
            throw new ComponentConfigurationException((Throwable)e);
        }
    }

    private MavenDeployable convertToDeployable(PlexusConfiguration configuration) throws ComponentConfigurationException {
        try {
            return this.doConvertToDeployable(configuration);
        }
        catch (Exception e) {
            throw new ComponentConfigurationException((Throwable)e);
        }
    }

    private MavenDeployable doConvertToDeployable(PlexusConfiguration configuration) throws PlexusConfigurationException {
        MavenDeployable deployable = new MavenDeployable();
        for (PlexusConfiguration propertyConfiguration : configuration.getChildren()) {
            PlexusConfiguration[] entries;
            String name = propertyConfiguration.getName();
            if (propertyConfiguration.getChild("list", false) != null) {
                PlexusConfiguration[] values = propertyConfiguration.getChild("list").getChildren();
                for (int i = 0; i < values.length; ++i) {
                    PlexusConfiguration valueConfiguration = values[i];
                    String indexName = name + "-EntryValue-" + i;
                    deployable.addValue(indexName, valueConfiguration.getValue());
                }
                continue;
            }
            if (propertyConfiguration.getChild("map", false) != null) {
                for (PlexusConfiguration entryConfiguration : entries = propertyConfiguration.getChild("map").getChildren()) {
                    String indexName = name + "-" + entryConfiguration.getName();
                    deployable.addValue(indexName, entryConfiguration.getValue());
                }
                continue;
            }
            if (propertyConfiguration.getChild("tag", false) != null) {
                for (PlexusConfiguration entryConfiguration : entries = propertyConfiguration.getChildren()) {
                    deployable.addTag(entryConfiguration.getValue());
                }
                continue;
            }
            String c = propertyConfiguration.getValue();
            deployable.addValue(name, c);
        }
        return deployable;
    }
}

