package com.xebialabs.deployit.maven.logic;

import com.google.common.base.Predicate;
import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.maven.MavenDeployed;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import static com.google.common.collect.Iterators.filter;

public class CustomDeployedsApplicationStrategy {

    Logger log = LoggerFactory.getLogger(CustomDeployedsApplicationStrategy.class);

    public Deployment merge(Deployment input, List<MavenDeployed> custom) {

        final List<ConfigurationItem> deployeds = input.getDeployeds();
        for (ConfigurationItem configurationItem : deployeds) {
            log.debug(" check {}", configurationItem);
            final String id = configurationItem.getId();
            final Iterator<? extends MavenDeployed> deployedIterator = filter(custom.iterator(), new Predicate<MavenDeployed>() {
                @Override
                public boolean apply(MavenDeployed input) {
                    return input.getId().equals(id);
                }
            });
            if (deployedIterator.hasNext()) {
                updateConfigurationItemValues(configurationItem, deployedIterator.next());
            } else {
                log.debug(" no configured deployed found with id " + configurationItem.getId());
            }
        }
        return input;
    }



    private void updateConfigurationItemValues(ConfigurationItem configurationItem, MavenDeployed configuredDeployed) {

        log.debug(" update values of {} with {}", configurationItem.getId(), configuredDeployed.getValues());

        for (Map.Entry<String, Object> e : configuredDeployed.getValues().entrySet()) {
            configurationItem.setProperty(e.getKey(), e.getValue());
        }

        if (configuredDeployed.getPlaceholders() != null)
            configurationItem.setProperty("placeholders", configuredDeployed.getPlaceholders());
    }
}
