/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.maven;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.engine.api.DeploymentService;
import com.xebialabs.deployit.engine.api.RepositoryService;
import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.maven.AbstractDeployitMojo;
import com.xebialabs.deployit.maven.MavenContainer;
import com.xebialabs.deployit.maven.helper.DeploymentHelper;
import com.xebialabs.deployit.maven.logic.CustomDeployedsApplicationStrategy;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class DeployMojo
extends AbstractDeployitMojo {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"deployit:deploy");
        this.boot();
        try {
            this.deploy();
        }
        finally {
            this.shutdown();
        }
        this.getLog().info((CharSequence)"End of deploy:deploy");
    }

    private void deploy() throws MojoExecutionException {
        Deployment generatedDeployment;
        ConfigurationItem deploymentPackage = this.importDar();
        if (Strings.emptyToNull((String)this.environmentId) == null && (this.environment == null || this.environment.isEmpty())) {
            throw new MojoExecutionException("Mandatory parameter environmentId is not set");
        }
        ConfigurationItem targetEnvironment = this.getDeploymentHelper().readCiOrNull(this.environmentId);
        if (targetEnvironment == null) {
            if (this.environment == null || this.environment.isEmpty()) {
                throw new MojoExecutionException("Environment does not exist and there are no members specified to create it.");
            }
            List members = Lists.transform(this.environment, (Function)new Function<MavenContainer, ConfigurationItem>(){

                public ConfigurationItem apply(MavenContainer input) {
                    return input.asConfigurationItem();
                }
            });
            try {
                targetEnvironment = this.getDeploymentHelper().createEnvironment(this.environmentId, members);
            }
            catch (DeploymentHelper.EnvironmentAlreadyExistsError e) {
                throw new RuntimeException(e);
            }
        }
        this.getDeploymentHelper().logEnvironment(targetEnvironment);
        DeploymentService deploymentService = this.communicator.getProxies().getDeploymentService();
        RepositoryService repositoryService = this.communicator.getProxies().getRepositoryService();
        Boolean update = this.getDeploymentHelper().isApplicationDeployed(deploymentPackage.getId(), targetEnvironment.getId());
        String currentVersion = null;
        if (update.booleanValue()) {
            this.getLog().info((CharSequence)" ... Application already exists => preparing update");
            generatedDeployment = deploymentService.prepareUpdate(deploymentPackage.getId(), this.getDeployedApplicationId(deploymentPackage.getId(), targetEnvironment.getId()));
            currentVersion = (String)repositoryService.read(this.getDeployedApplicationId(deploymentPackage.getId(), targetEnvironment.getId())).getProperty("version");
            if (this.generateDeployedOnUpgrade && !this.hasDeployeds()) {
                generatedDeployment = deploymentService.generateAllDeployeds(generatedDeployment);
            }
        } else {
            this.getLog().info((CharSequence)" ... Application not found in deployed => preparing for initial deployment");
            generatedDeployment = deploymentService.prepareInitial(deploymentPackage.getId(), targetEnvironment.getId());
            generatedDeployment = deploymentService.generateAllDeployeds(generatedDeployment);
        }
        if (this.deployeds != null && this.deployeds.size() > 0) {
            this.getLog().debug((CharSequence)"Updating generated deployeds with the configured deployeds");
            generatedDeployment = new CustomDeployedsApplicationStrategy().merge(generatedDeployment, this.deployeds);
        }
        if (this.explicitDeployeds) {
            generatedDeployment = this.getDeploymentHelper().attachExplicitDeployeds(generatedDeployment, this.deployeds);
        }
        if (!Strings.isNullOrEmpty((String)this.orchestrator)) {
            this.getLog().info((CharSequence)("Using orchestrator: " + this.orchestrator));
            generatedDeployment.getDeployedApplication().setProperty("orchestrator", (Object)this.orchestrator);
        }
        this.getLog().info((CharSequence)"Deployeds to be included into generatedDeployment:");
        for (ConfigurationItem d : generatedDeployment.getDeployeds()) {
            this.getLog().info((CharSequence)("    -> " + d.getId()));
        }
        this.getLog().info((CharSequence)"Creating a task");
        String taskId = null;
        try {
            taskId = deploymentService.createTask(this.getDeploymentHelper().validateDeployment(generatedDeployment));
        }
        catch (DeploymentHelper.DeploymentValidationError validationError) {
            for (ValidationMessage validationMessage : validationError.getValidationMessages()) {
                this.getLog().error((CharSequence)validationMessage.toString());
            }
            throw new RuntimeException(validationError);
        }
        this.getLog().info((CharSequence)("    -> task id: " + taskId));
        if (this.testMode) {
            this.getLog().info((CharSequence)" ... Test mode discovered => displaying and cancelling the generated task");
            this.getDeploymentHelper().logTaskState(taskId);
            this.communicator.getProxies().getTaskService().cancel(taskId);
            return;
        }
        if (this.skipMode) {
            this.getLog().info((CharSequence)" ... Skip mode discovered");
            this.getDeploymentHelper().skipAllSteps(taskId);
        }
        this.getLog().info((CharSequence)"Executing generatedDeployment task");
        try {
            TaskExecutionState taskExecutionState = this.getDeploymentHelper().executeAndArchiveTask(taskId);
            if (taskExecutionState.equals((Object)TaskExecutionState.STOPPED)) {
                throw new MojoExecutionException(String.format("Errors when executing task %s. Read logs above to find exact reason.", taskId));
            }
        }
        catch (IllegalStateException e) {
            if (this.cancelTaskOnError) {
                this.getLog().info((CharSequence)("cancel task on error " + taskId));
                this.communicator.getProxies().getTaskService().cancel(taskId);
            }
            throw e;
        }
        if (this.deletePreviouslyDeployedDar && update.booleanValue() && currentVersion != null) {
            this.getLog().info((CharSequence)("removing previous version " + currentVersion));
            try {
                repositoryService.delete(currentVersion);
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)("Cannot delete " + currentVersion + ": " + e.getMessage()));
            }
        }
    }

    private String getDeployedApplicationId(String source, String target) {
        ArrayList splitSource = Lists.newArrayList((Iterable)Splitter.on((String)"/").split((CharSequence)source));
        String appName = (String)splitSource.get(splitSource.size() - 2);
        return Joiner.on((String)"/").join((Object)target, (Object)appName, new Object[0]);
    }
}

