/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.maven;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.maven.Deployed;
import java.util.LinkedList;
import java.util.Map;

public class MavenDeployed
extends Deployed {
    protected String id;
    protected String type;
    protected final Map<String, Object> values = Maps.newHashMap();
    protected final Map<String, String> placeholders = Maps.newHashMap();

    public String getContainer() {
        LinkedList split = Lists.newLinkedList((Iterable)Splitter.on((String)"/").split((CharSequence)this.id));
        split.removeLast();
        return Joiner.on((String)"/").join((Iterable)split);
    }

    public String getDeployable(String version) {
        LinkedList split = Lists.newLinkedList((Iterable)Splitter.on((String)"/").split((CharSequence)this.id));
        return Joiner.on((String)"/").join((Object)version, split.removeLast(), new Object[0]);
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public Map<String, Object> getValues() {
        return this.values;
    }

    public void addPlaceholder(String key, String value) {
        this.placeholders.put(key, value);
    }

    public Map<String, String> getPlaceholders() {
        return this.placeholders;
    }

    public String toString() {
        return "Deployed{id='" + this.id + '\'' + ", type='" + this.type + '\'' + ", values=" + this.values + ", placeholders=" + this.placeholders + '}';
    }

    public void addValues(String name, Object value) {
        Preconditions.checkNotNull((Object)name);
        if ("placeholders".equals(name)) {
            return;
        }
        Preconditions.checkNotNull((Object)value, (Object)String.format("null value for %s", name));
        if ("id".equals(name)) {
            this.id = value.toString();
            return;
        }
        if ("type".equals(name)) {
            this.type = value.toString();
            return;
        }
        this.values.put(name, value);
    }
}

