package com.xebialabs.deployit.maven.packager;

import com.xebialabs.deployit.client.DarPackager;
import com.xebialabs.deployit.maven.listener.MavenDeploymentListener;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

import java.io.File;
import java.text.SimpleDateFormat;

public class MavenDarPackager extends DarPackager {
	public MavenDarPackager(MavenProject project, Log log, boolean timestampedVersion) {
		super(project.getArtifactId(),
				project.getVersion(),
				new File(project.getBuild().getDirectory()),
				new MavenDeploymentListener(log),
				getCIVersion(project, timestampedVersion));
	}

	private static String getCIVersion(MavenProject project, boolean timestampedVersion) {
		String ciVersion = project.getVersion();
		if (timestampedVersion) {
			SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HHmmss");
			ciVersion = project.getVersion() + "-" + dateFormat.format(System.currentTimeMillis());
			//SNAPSHOT is removed from the timestamped version (as maven deploy does).
			ciVersion = ciVersion.replace("-SNAPSHOT", "");
		}
		return ciVersion;
	}
}
