/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.maven.packager;

import com.google.common.base.Strings;
import com.xebialabs.deployit.maven.Deployable;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.io.IOUtils;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;

public class ManifestPackager {
    public static final String DEPLOYMENT_PACKAGE_DIR = "deployment-package";
    public static final String APPLICATION = "CI-Application";
    public static final String VERSION = "CI-Version";
    private final MavenProject project;
    private final Log log;
    private final boolean timestampedVersion;
    private final File outputDirectory;
    private final File targetDirectory;
    private final Manifest manifest = new Manifest();

    public ManifestPackager(MavenProject project, Log log, boolean timestampedVersion) {
        this.project = project;
        this.log = log;
        this.timestampedVersion = timestampedVersion;
        this.outputDirectory = new File(project.getBuild().getDirectory());
        this.targetDirectory = new File(this.outputDirectory, DEPLOYMENT_PACKAGE_DIR + File.separator + project.getArtifactId() + File.separator + project.getVersion());
        this.targetDirectory.mkdirs();
    }

    public void addDeployables(List<Deployable> deployables) {
        for (Deployable deployable : deployables) {
            this.addDeployable(deployable);
        }
    }

    private void addDeployable(Deployable deployable) {
        this.log.debug((CharSequence)("addDeployable " + deployable));
        deployable.consolidate(this.project);
        Map<String, Attributes> entries = this.manifest.getEntries();
        Attributes attributes = new Attributes();
        attributes.putValue("CI-Type", deployable.getType());
        attributes.putValue("CI-Name", deployable.getName());
        for (Map.Entry<String, String> me : deployable.getValues().entrySet()) {
            attributes.putValue(me.getKey(), me.getValue());
        }
        entries.put(deployable.getEntryName(), attributes);
        if (Strings.isNullOrEmpty((String)deployable.getFileSystemLocation())) {
            return;
        }
        File location = new File(deployable.getFileSystemLocation());
        try {
            File deployableTargetFile;
            if (!location.exists()) {
                throw new IOException(String.format("source location %s doesn't exist", location));
            }
            if (location.isFile()) {
                deployableTargetFile = new File(this.targetDirectory, deployable.getEntryName());
                deployableTargetFile.getParentFile().mkdirs();
                this.log.debug((CharSequence)String.format(" copy file %s to %s", location, deployableTargetFile));
                FileUtils.copyFile((File)location, (File)deployableTargetFile);
            } else {
                deployableTargetFile = this.targetDirectory;
                this.log.debug((CharSequence)String.format(" copy dir  %s to %s", location, deployableTargetFile));
                this.copyToDir(location, deployableTargetFile);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Fail to copy of %s to %s ", location, this.targetDirectory), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform() {
        String pomVersion;
        Attributes mainAttributes = this.manifest.getMainAttributes();
        mainAttributes.putValue("Manifest-Version", "1.0");
        mainAttributes.putValue("Deployit-Package-Format-Version", "1.3");
        mainAttributes.putValue(APPLICATION, this.project.getArtifactId());
        String darVersion = pomVersion = this.project.getVersion();
        if (this.timestampedVersion) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HHmmss");
            darVersion = pomVersion + "-" + dateFormat.format(System.currentTimeMillis());
            darVersion = darVersion.replace("-SNAPSHOT", "");
        }
        mainAttributes.putValue(VERSION, darVersion);
        File meta_inf = new File(this.targetDirectory, "META-INF");
        meta_inf.mkdirs();
        File manifestFile = new File(meta_inf, "MANIFEST.MF");
        this.log.info((CharSequence)("Generate manifest file " + manifestFile.getAbsolutePath()));
        FileOutputStream fos = null;
        try {
            this.dumpManifest();
            fos = new FileOutputStream(manifestFile);
            this.manifest.write(fos);
        }
        catch (IOException e) {
            try {
                new RuntimeException("generation of the manifest file failed", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)fos);
        }
        IOUtils.closeQuietly((OutputStream)fos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpManifest() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.manifest.write(baos);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)baos);
        }
        this.log.debug((CharSequence)new String(baos.toByteArray()));
    }

    public void seal() throws MojoExecutionException {
        try {
            File darFile = this.getDarFile();
            this.log.info((CharSequence)("Seal the archive in " + darFile));
            MavenArchiver mvnArchiver = new MavenArchiver();
            mvnArchiver.setArchiver(new JarArchiver());
            mvnArchiver.setOutputFile(darFile);
            mvnArchiver.getArchiver().addDirectory(this.targetDirectory);
            File manifestFile = this.getManifestFile();
            this.log.debug((CharSequence)("set Manifest file of the archive " + manifestFile));
            mvnArchiver.getArchiver().setManifest(manifestFile);
            mvnArchiver.createArchive(this.project, new MavenArchiveConfiguration());
            this.project.getArtifact().setFile(darFile);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error when sealing DAR", e);
        }
    }

    public File getDarFile() {
        return new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + ".dar");
    }

    public File getManifestFile() {
        return new File(this.targetDirectory, "META-INF/MANIFEST.MF");
    }

    private void copyToDir(File sourceDirectory, File targetDir) throws IOException {
        File destination = new File(targetDir, sourceDirectory.getName());
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.addDefaultExcludes();
        scanner.setBasedir(sourceDirectory.getPath());
        scanner.scan();
        String[] files = scanner.getIncludedFiles();
        if (files != null && files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                File sourceFile = new File(scanner.getBasedir(), files[i]);
                File targetFile = new File(destination, files[i]);
                this.log.debug((CharSequence)("  copy " + files[i] + " to " + targetFile));
                FileUtils.copyFile((File)sourceFile, (File)targetFile);
            }
        }
    }
}

