package com.xebialabs.deployit.maven.cli;

import com.xebialabs.deployit.core.api.DeploymentProxy;
import com.xebialabs.deployit.core.api.dto.Deployment;
import com.xebialabs.deployit.core.api.dto.Steps;

import static com.xebialabs.deployit.maven.cli.ResponseExtractor.getEntity;

public class DeploymentClient {

	private final DeploymentProxy deploymentProxy;

	public DeploymentClient(MavenProxies proxies) {
		this.deploymentProxy = proxies.getDeployment();
	}

	public Deployment prepareInitial(String version, String environment) {
		return getEntity(deploymentProxy.prepareInitial(version, environment));
	}

	public Deployment prepareUpgrade(String version, String deployedApplication) {
		return getEntity(deploymentProxy.prepareUpgrade(version, deployedApplication));
	}

	public Deployment generateAllDeployeds(Deployment deployment) {
		return getEntity(deploymentProxy.generateAllDeployeds(deployment));
	}

	public Deployment generateSingleDeployed(String deployable, String container, String type, Deployment deployment) {
		return getEntity(deploymentProxy.generateSingleDeployed(deployable, container, type, deployment));
	}

	public Deployment validate(Deployment deployment) {
		return getEntity(deploymentProxy.validate(deployment));
	}

	public Steps deploy(Deployment deployment) {
		return getEntity(deploymentProxy.deploy(deployment));
	}

	public Steps undeploy(String deployedApplication) {
		return getEntity(deploymentProxy.undeploy(deployedApplication));
	}
}
