package com.xebialabs.deployit.maven.cli;

import com.google.common.base.Joiner;
import com.xebialabs.deployit.core.api.dto.RepositoryObject;
import com.xebialabs.deployit.core.api.dto.TaskInfo;

public class DeployitClient {
	private final MavenProxies proxies;

	public DeployitClient(MavenProxies proxies) {
		this.proxies = proxies;
	}

	public RepositoryObject importPackage(final String importablePackageName) {
		return new ImportHelper().doImport(proxies.getAuthentication().getHttpClient(), proxies.getHost(), importablePackageName);
	}

	public TaskInfo retrieveTaskInfo(final String taskId) {
		return new ResponseExtractor(proxies.getTaskRegistry().getTaskInfo(taskId)).getEntity();
	}

	public void stopTask(String taskId) {
		new ResponseExtractor(proxies.getTaskRegistry().stop(taskId));
	}

	public void startTask(String taskId) {
		new ResponseExtractor(proxies.getTaskRegistry().start(taskId));
	}

	public void startTaskAndWait(final String taskId) {
		startTask(taskId);
		// Wait until done/failed
		boolean done = false;
		TaskInfo ti = null;
		while (!done) {
			ti = new ResponseExtractor(proxies.getTaskRegistry().getTaskInfo(taskId)).getEntity();
			final String st = ti.getState();
			if ("DONE".equals(st) || "ABORTED".equals(st) || "STOPPED".equals(st)) {
				done = true;
			}
			try {
				Thread.sleep(1000);
			} catch (InterruptedException e) {
				Thread.currentThread().interrupt();
			}
		}
	}

	public void abortTask(String taskId) {
		new ResponseExtractor(proxies.getTaskRegistry().abort(taskId));
	}

	public void cancelTask(String taskId) {
		new ResponseExtractor(proxies.getTaskRegistry().cancel(taskId));
	}

	public void skipSteps(String taskId, Integer[] stepIds) {
		final String ids = Joiner.on(",").join(stepIds);
		new ResponseExtractor(proxies.getTaskRegistry().toggleSkipSteps(taskId, ids));
	}


}
