/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.maven;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.core.api.dto.RepositoryObject;
import com.xebialabs.deployit.maven.Container;
import com.xebialabs.deployit.maven.Deployable;
import com.xebialabs.deployit.maven.Deployed;
import com.xebialabs.deployit.maven.cli.MavenCli;
import com.xebialabs.deployit.maven.cli.MavenCliOptions;
import com.xebialabs.deployit.maven.packager.ManifestPackager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public abstract class AbstractDeployitMojo
extends AbstractMojo {
    protected MavenProject project;
    protected String mainArtifactName;
    protected boolean skipMode;
    protected boolean testMode;
    protected boolean failIfNoStepsAreGenerated;
    private String serverAddress;
    private int port;
    private String username;
    private String password;
    private String context;
    protected boolean secured;
    private String environmentId;
    protected List<Deployed> deployeds;
    protected List<Deployable> deployables;
    protected List<Container> environment;
    protected boolean timestampedVersion;
    protected boolean deletePreviouslyDeployedDar;
    protected boolean explicitDeployeds;
    protected ManifestPackager packager;
    protected MavenCli client;

    protected MavenCli getClient() throws MojoExecutionException {
        if (this.client == null) {
            MavenCliOptions options = new MavenCliOptions();
            options.setHost(this.serverAddress);
            options.setPort(this.port);
            options.setUsername(this.username);
            options.setPassword(this.password);
            options.setSkipMode(this.skipMode);
            options.setTestMode(this.testMode);
            options.setContext(this.context);
            options.setExplicitMappings(this.explicitDeployeds);
            options.setSecured(this.secured);
            options.setFailIfNoStepsAreGenerated(this.failIfNoStepsAreGenerated);
            try {
                this.client = new MavenCli(options, this.getLog());
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error when creating MavenCli", e);
            }
        }
        return this.client;
    }

    protected void deploy() throws MojoExecutionException {
        RepositoryObject deploymentPackage = this.importDar();
        RepositoryObject environment = this.fetchEnvironment();
        this.getLog().info((CharSequence)String.format("-- Deploy %s on %s", deploymentPackage.getId(), environment.getId()));
        String previousPackageId = this.getClient().deploy(deploymentPackage.getId(), environment.getId(), this.deployeds);
        if (this.shouldDeletePreviousVersion(previousPackageId)) {
            this.getLog().info((CharSequence)("Delete previously deployed dar " + previousPackageId));
            this.getClient().delete(previousPackageId);
        }
    }

    private boolean shouldDeletePreviousVersion(String previousPackageId) {
        if (this.testMode) {
            return false;
        }
        if (this.skipMode) {
            return false;
        }
        return this.deletePreviouslyDeployedDar && StringUtils.isNotBlank((String)previousPackageId);
    }

    protected RepositoryObject importDar() throws MojoExecutionException {
        File darFile = this.getPackager().getDarFile();
        if (!darFile.exists()) {
            this.getLog().info((CharSequence)("Dar file does not exist " + darFile));
            this.getLog().info((CharSequence)"generate it...");
            this.getPackager().perform();
            this.getPackager().seal();
        }
        return this.importDar(darFile);
    }

    protected void undeploy() throws MojoExecutionException {
        this.getClient().undeployAndWait(this.environmentId + "/" + this.mainArtifactName);
    }

    protected RepositoryObject importDar(File darFile) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Import dar file " + darFile));
        return this.getClient().importPackage(darFile);
    }

    protected RepositoryObject fetchEnvironment() throws MojoExecutionException {
        if (StringUtils.isBlank((String)this.environmentId)) {
            throw new MojoExecutionException("environmentId is not set");
        }
        try {
            this.getLog().info((CharSequence)("read the environment " + this.environmentId));
            RepositoryObject repositoryObject = this.getClient().get(this.environmentId);
            if (this.getLog().isDebugEnabled() && repositoryObject != null) {
                this.getLog().debug((CharSequence)(" dump members of " + this.environmentId));
                for (Object m : (List)repositoryObject.getValues().get("members")) {
                    this.getLog().debug((CharSequence)("  -- member " + m));
                }
            }
            return repositoryObject;
        }
        catch (Exception e) {
            this.getLog().debug((CharSequence)e.getMessage());
            if (this.environment == null) {
                throw new MojoExecutionException("Cannot fetch environment " + this.environmentId + " and no members are defined in <environnment>", e);
            }
            this.getLog().info((CharSequence)"Create the members of environment");
            ArrayList members = Lists.newArrayList();
            for (Container each : this.environment) {
                this.getLog().info((CharSequence)(" create " + each.getId()));
                this.getClient().create(each);
                if (!each.isAddedToEnvironment()) continue;
                members.add(each.getId());
            }
            this.getLog().info((CharSequence)("Create environment " + this.environmentId));
            Container ciEnvironment = new Container();
            ciEnvironment.setId(this.environmentId);
            ciEnvironment.setType("Environment");
            ciEnvironment.addParameter("members", members);
            return this.getClient().create(ciEnvironment);
        }
    }

    ManifestPackager getPackager() {
        if (this.packager == null) {
            this.packager = new ManifestPackager(this.project, this.getLog(), this.timestampedVersion || this.isSnapshotVersion());
            if (this.project.getArtifact().getType().equalsIgnoreCase("war") || this.project.getArtifact().getType().equalsIgnoreCase("ear")) {
                Deployable mainArtifact = new Deployable();
                mainArtifact.setGroupId(this.project.getGroupId());
                mainArtifact.setArtifactId(this.mainArtifactName);
                if (this.project.getArtifact().getType().equalsIgnoreCase("war")) {
                    mainArtifact.setType("jee.War");
                } else {
                    mainArtifact.setType("jee.Ear");
                }
                File file = this.project.getArtifact().getFile();
                if (file != null) {
                    mainArtifact.setFileSystemLocation(file.toString());
                    mainArtifact.setLocation(file.toString());
                }
                if (this.deployables == null) {
                    this.deployables = Lists.newArrayList();
                }
                this.deployables.add(mainArtifact);
            }
            this.packager.addDeployables(this.deployables);
        }
        return this.packager;
    }

    private boolean isSnapshotVersion() {
        return this.project.getVersion().contains("SNAPSHOT");
    }
}

