/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.maven.converter;

import com.xebialabs.deployit.maven.Container;
import com.xebialabs.deployit.maven.Deployable;
import com.xebialabs.deployit.maven.Deployed;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.AbstractConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;

public class DeployitCIConverter
extends AbstractConfigurationConverter {
    public static final String MAVEN_EXPRESSION_EVALUATOR_ID = "maven.expressionEvaluator";
    public static final String ROLE = ConfigurationConverter.class.getName();
    static final String ADD_TO_ENV = "addToEnv";

    public boolean canConvert(Class type) {
        return Container.class.isAssignableFrom(type) || Deployed.class.isAssignableFrom(type) || Deployable.class.isAssignableFrom(type);
    }

    public Object fromConfiguration(ConverterLookup converterLookup, PlexusConfiguration configuration, Class type, Class baseType, ClassLoader classLoader, ExpressionEvaluator expressionEvaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        if (type.equals(Container.class)) {
            Container ci = new Container();
            try {
                String add2Env = configuration.getAttribute(ADD_TO_ENV);
                if (add2Env != null) {
                    ci.setAddedToEnvironment(Boolean.parseBoolean(add2Env));
                }
            }
            catch (Exception e) {
                throw new ComponentConfigurationException("getValue error", (Throwable)e);
            }
            for (PlexusConfiguration plexusConfiguration : configuration.getChildren()) {
                try {
                    String name = plexusConfiguration.getName();
                    String c = plexusConfiguration.getValue();
                    ci.addParameter(name, c);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return ci;
        }
        if (type.equals(Deployable.class)) {
            Deployable deployable = new Deployable();
            for (PlexusConfiguration plexusConfiguration : configuration.getChildren()) {
                try {
                    String name = plexusConfiguration.getName();
                    String c = plexusConfiguration.getValue();
                    deployable.addValue(name, c);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return deployable;
        }
        if (type.equals(Deployed.class)) {
            Deployed deployed = new Deployed();
            for (PlexusConfiguration plexusConfiguration : configuration.getChildren()) {
                try {
                    String name = plexusConfiguration.getName();
                    String c = plexusConfiguration.getValue();
                    deployed.addValues(name, c);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            for (PlexusConfiguration entry : configuration.getChild("placeholders").getChildren()) {
                PlexusConfiguration k = entry.getChild("k");
                PlexusConfiguration v = entry.getChild("v");
                try {
                    deployed.addPlaceholder(k.getValue(), v.getValue());
                }
                catch (PlexusConfigurationException e) {
                    throw new ComponentConfigurationException("kv getValue error", (Throwable)e);
                }
            }
            return deployed;
        }
        throw new ComponentConfigurationException("type not handled (" + type + ")");
    }
}

