/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.maven;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;

public class Deployable {
    private String type;
    private String location;
    private String name;
    private String groupId;
    private String artifactId;
    private String fileSystemLocation;
    private String entryName;
    private final Map<String, String> values = Maps.newHashMap();

    public void addValue(String name, String value) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)value, (Object)String.format("null value for %s", name));
        try {
            Field declaredField = Deployable.class.getDeclaredField(name);
            declaredField.set(this, value);
        }
        catch (NoSuchFieldException e) {
            this.values.put("CI-" + name, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(String.format("Cannot set %s value on field %s", name, value), e);
        }
    }

    public String toString() {
        return "Deployable{type='" + this.type + '\'' + ", location='" + this.location + '\'' + ", name='" + this.name + '\'' + ", groupId='" + this.groupId + '\'' + ", artifactId='" + this.artifactId + '\'' + ", fileSystemLocation='" + this.fileSystemLocation + '\'' + ", entryName='" + this.entryName + '\'' + ", values=" + this.values + '}';
    }

    public void consolidate(MavenProject project) {
        if (this.isMavenArtefact()) {
            if (Strings.isNullOrEmpty((String)this.location)) {
                String artifactFile;
                String key = this.groupId + ":" + this.artifactId;
                Artifact artifact = (Artifact)project.getArtifactMap().get(key);
                Set dependencyArtifacts = project.getDependencyArtifacts();
                if (dependencyArtifacts != null) {
                    for (Object o : dependencyArtifacts) {
                        Artifact da = (Artifact)o;
                        String artifactKey = da.getGroupId() + ":" + da.getArtifactId();
                        if (!artifactKey.equals(key)) continue;
                        artifact = da;
                    }
                }
                if (artifact == null) {
                    throw new IllegalStateException(String.format("The artifact %s  not found in the project dependencies %s", key, dependencyArtifacts));
                }
                File file = artifact.getFile();
                if (file == null) {
                    throw new IllegalStateException(String.format("Associated file of %s is empty", artifact));
                }
                this.location = artifactFile = file.toString();
                this.fileSystemLocation = artifactFile;
            }
            if (Strings.isNullOrEmpty((String)this.name)) {
                this.name = this.artifactId;
            }
            if (Strings.isNullOrEmpty((String)this.entryName)) {
                this.entryName = this.type + "/" + new File(this.fileSystemLocation).getName();
            }
        } else if (this.isFileSystemLocation(project)) {
            File fileLocation = new File(this.location);
            File fileSysLoca = fileLocation.isAbsolute() ? fileLocation : new File(project.getBasedir(), this.location);
            this.fileSystemLocation = fileSysLoca.getPath();
            if (Strings.isNullOrEmpty((String)this.entryName)) {
                this.entryName = this.location;
            }
        } else if (Strings.isNullOrEmpty((String)this.entryName)) {
            Preconditions.checkNotNull((Object)this.name, (String)"name should not be null on this %s", (Object[])new Object[]{this});
            this.entryName = this.name;
        }
    }

    private boolean isFileSystemLocation(MavenProject project) {
        if (Strings.isNullOrEmpty((String)this.location)) {
            return false;
        }
        return new File(this.location).exists() || new File(project.getBasedir(), this.location).exists();
    }

    private boolean isMavenArtefact() {
        return !Strings.isNullOrEmpty((String)this.groupId) && !Strings.isNullOrEmpty((String)this.artifactId);
    }

    public String getFileSystemLocation() {
        return this.fileSystemLocation;
    }

    public Map<String, String> getValues() {
        return this.values;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setFileSystemLocation(String fileSystemLocation) {
        this.fileSystemLocation = fileSystemLocation;
    }
}

