/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.maven.converter;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.maven.ConfigurationItem;
import com.xebialabs.deployit.maven.MappingItem;
import com.xebialabs.deployit.maven.MiddlewareResource;
import java.util.ArrayList;
import java.util.HashMap;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.AbstractConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;

public class DeployitCIConverter
extends AbstractConfigurationConverter {
    public static final String MAVEN_EXPRESSION_EVALUATOR_ID = "maven.expressionEvaluator";
    public static final String ROLE = ConfigurationConverter.class.getName();
    static final String TYPE = "type";
    static final String ADD_TO_ENV = "addToEnv";

    public boolean canConvert(Class type) {
        return ConfigurationItem.class.isAssignableFrom(type) || MiddlewareResource.class.isAssignableFrom(type);
    }

    public Object fromConfiguration(ConverterLookup converterLookup, PlexusConfiguration configuration, Class type, Class baseType, ClassLoader classLoader, ExpressionEvaluator expressionEvaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        if (type.equals(ConfigurationItem.class)) {
            ConfigurationItem ci = new ConfigurationItem();
            try {
                String typeAttribute = configuration.getAttribute(TYPE);
                if (typeAttribute != null) {
                    throw new ComponentConfigurationException("'Type' xml attribute is no more supported, use <type>" + typeAttribute + "</type> instead");
                }
                String add2Env = configuration.getAttribute(ADD_TO_ENV);
                if (add2Env != null) {
                    ci.setAddedToEnvironment(Boolean.parseBoolean(add2Env));
                }
            }
            catch (Exception e) {
                throw new ComponentConfigurationException("getValue error", (Throwable)e);
            }
            for (PlexusConfiguration plexusConfiguration : configuration.getChildren()) {
                try {
                    String name = plexusConfiguration.getName();
                    String c = plexusConfiguration.getValue();
                    ci.addParameter(name, c);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return ci;
        }
        if (type.equals(MappingItem.class)) {
            PlexusConfiguration[] children;
            MappingItem ci = new MappingItem();
            PlexusConfiguration source = configuration.getChild("source");
            PlexusConfiguration target = configuration.getChild("target");
            PlexusConfiguration mainType = configuration.getChild(TYPE);
            PlexusConfiguration kvPairs = configuration.getChild("keyValuePairs");
            ArrayList kvParsed = Lists.newArrayList();
            for (PlexusConfiguration pair : kvPairs.getChildren()) {
                PlexusConfiguration k = pair.getChild("k");
                PlexusConfiguration v = pair.getChild("v");
                try {
                    HashMap map = Maps.newHashMap();
                    map.put("key", k.getValue());
                    map.put("value", v.getValue());
                    kvParsed.add(map);
                }
                catch (PlexusConfigurationException e) {
                    throw new ComponentConfigurationException("kv getValue error", (Throwable)e);
                }
            }
            ci.setKeyValuePairs(kvParsed);
            try {
                ci.setSource(source.getValue());
                ci.setTarget(target.getValue());
                ci.setType(mainType.getValue());
            }
            catch (PlexusConfigurationException e) {
                throw new ComponentConfigurationException("getValue error", (Throwable)e);
            }
            try {
                String typeAttribute = configuration.getAttribute(TYPE);
                if (typeAttribute != null) {
                    throw new ComponentConfigurationException("'Type' xml attribute is no more supported, use <type>" + typeAttribute + "</type> instead");
                }
            }
            catch (Exception e) {
                throw new ComponentConfigurationException("getValue error", (Throwable)e);
            }
            for (PlexusConfiguration plexusConfiguration : children = configuration.getChildren()) {
                try {
                    String name = plexusConfiguration.getName();
                    String value = plexusConfiguration.getValue();
                    if (value != null) {
                        ci.addParameter(name, value);
                    }
                    if (!name.endsWith("s")) continue;
                    String subName = name.substring(0, name.length() - 1);
                    ArrayList propertyValueAsACollection = Lists.newArrayList();
                    for (PlexusConfiguration subPlexus : plexusConfiguration.getChildren(subName)) {
                        propertyValueAsACollection.add(subPlexus.getValue("NoValueFound for node " + name));
                    }
                    ci.addParameter(name, propertyValueAsACollection);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return ci;
        }
        if (type.equals(MiddlewareResource.class)) {
            MiddlewareResource mr = new MiddlewareResource();
            for (PlexusConfiguration plexusConfiguration : configuration.getChildren()) {
                try {
                    String name = plexusConfiguration.getName();
                    String c = plexusConfiguration.getValue();
                    mr.addParameter(name, c);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return mr;
        }
        throw new ComponentConfigurationException("type not handled (" + type + ")");
    }
}

