/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.maven;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "com.xebialabs.deployit:maven-deployit-plugin:3.0.5", 0);
        this.append(sb, "", 0);
        this.append(sb, "Deployit Maven Mojo", 0);
        this.append(sb, "(no description available)", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 5 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "clean".equals(this.goal)) {
            this.append(sb, "deployit:clean", 0);
            this.append(sb, "Clean (Undeploy) the target environment.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "deletePreviouslyDeployedDar (Default: false)", 2);
                this.append(sb, "Perform a skipped deployment before clean it.", 3);
                this.append(sb, "Expression: ${deployit.delete.previous.dar}", 3);
                this.append(sb, "", 0);
                this.append(sb, "deployableArtifacts", 2);
                this.append(sb, "Additional deployables artifacts", 3);
                this.append(sb, "", 0);
                this.append(sb, "environment", 2);
                this.append(sb, "List of ConfigurationItem in the target environment.", 3);
                this.append(sb, "", 0);
                this.append(sb, "environmentId", 2);
                this.append(sb, "Id of the environment used for the deployment.", 3);
                this.append(sb, "Expression: ${deployit.environmentId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "failIfNoStepsAreGenerated (Default: false)", 2);
                this.append(sb, "If a deployments leads no steps, fail the build.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generateManifestOnly (Default: false)", 2);
                this.append(sb, "Only the Manifest file will be generate. Do not copy files when generating Deployment package", 3);
                this.append(sb, "", 0);
                this.append(sb, "mappings", 2);
                this.append(sb, "List of the Mapping", 3);
                this.append(sb, "", 0);
                this.append(sb, "middlewareResources", 2);
                this.append(sb, "Additional resources such as Database, Apache plugin configuration, JMS Queues...", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "password used to connect to a remote server", 3);
                this.append(sb, "Expression: ${deployit.password}", 3);
                this.append(sb, "", 0);
                this.append(sb, "port (Default: 4516)", 2);
                this.append(sb, "Deployit Listen port", 3);
                this.append(sb, "Expression: ${deployit.port}", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "The maven project.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${project}", 3);
                this.append(sb, "", 0);
                this.append(sb, "remoteServerMode (Default: true)", 2);
                this.append(sb, "Tell the plugin it must connect to a remote Deployit Server. The following properties become mandatory: username, password, serverAddress, port. The default value is true. Note: the maven plugin does not support the local server mode anymore.", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverAddress", 2);
                this.append(sb, "Deployit server address", 3);
                this.append(sb, "Expression: ${deployit.server}", 3);
                this.append(sb, "", 0);
                this.append(sb, "testmode (Default: false)", 2);
                this.append(sb, "Activate the test mode, the steps are not executed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "timestampedVersion (Default: false)", 2);
                this.append(sb, "Use this attribute to add a timestamp to the version of the deployit package. by default, SNAPSHOT versions are automatically timestamped", 3);
                this.append(sb, "Expression: ${deployit.timestamp}", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "username used to connect to a remote server", 3);
                this.append(sb, "Expression: ${deployit.username}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "deploy".equals(this.goal)) {
            this.append(sb, "deployit:deploy", 0);
            this.append(sb, "Deploy artifacts to the target environment.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "deletePreviouslyDeployedDar (Default: false)", 2);
                this.append(sb, "Perform a skipped deployment before clean it.", 3);
                this.append(sb, "Expression: ${deployit.delete.previous.dar}", 3);
                this.append(sb, "", 0);
                this.append(sb, "deployableArtifacts", 2);
                this.append(sb, "Additional deployables artifacts", 3);
                this.append(sb, "", 0);
                this.append(sb, "environment", 2);
                this.append(sb, "List of ConfigurationItem in the target environment.", 3);
                this.append(sb, "", 0);
                this.append(sb, "environmentId", 2);
                this.append(sb, "Id of the environment used for the deployment.", 3);
                this.append(sb, "Expression: ${deployit.environmentId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "failIfNoStepsAreGenerated (Default: false)", 2);
                this.append(sb, "If a deployments leads no steps, fail the build.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generateManifestOnly (Default: false)", 2);
                this.append(sb, "Only the Manifest file will be generate. Do not copy files when generating Deployment package", 3);
                this.append(sb, "", 0);
                this.append(sb, "mappings", 2);
                this.append(sb, "List of the Mapping", 3);
                this.append(sb, "", 0);
                this.append(sb, "middlewareResources", 2);
                this.append(sb, "Additional resources such as Database, Apache plugin configuration, JMS Queues...", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "password used to connect to a remote server", 3);
                this.append(sb, "Expression: ${deployit.password}", 3);
                this.append(sb, "", 0);
                this.append(sb, "port (Default: 4516)", 2);
                this.append(sb, "Deployit Listen port", 3);
                this.append(sb, "Expression: ${deployit.port}", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "The maven project.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${project}", 3);
                this.append(sb, "", 0);
                this.append(sb, "remoteServerMode (Default: true)", 2);
                this.append(sb, "Tell the plugin it must connect to a remote Deployit Server. The following properties become mandatory: username, password, serverAddress, port. The default value is true. Note: the maven plugin does not support the local server mode anymore.", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverAddress", 2);
                this.append(sb, "Deployit server address", 3);
                this.append(sb, "Expression: ${deployit.server}", 3);
                this.append(sb, "", 0);
                this.append(sb, "testmode (Default: false)", 2);
                this.append(sb, "Activate the test mode, the steps are not executed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "timestampedVersion (Default: false)", 2);
                this.append(sb, "Use this attribute to add a timestamp to the version of the deployit package. by default, SNAPSHOT versions are automatically timestamped", 3);
                this.append(sb, "Expression: ${deployit.timestamp}", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "username used to connect to a remote server", 3);
                this.append(sb, "Expression: ${deployit.username}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "generate-deployment-package".equals(this.goal)) {
            this.append(sb, "deployit:generate-deployment-package", 0);
            this.append(sb, "Build up the Deployit Deployment Package", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "deletePreviouslyDeployedDar (Default: false)", 2);
                this.append(sb, "Perform a skipped deployment before clean it.", 3);
                this.append(sb, "Expression: ${deployit.delete.previous.dar}", 3);
                this.append(sb, "", 0);
                this.append(sb, "deployableArtifacts", 2);
                this.append(sb, "Additional deployables artifacts", 3);
                this.append(sb, "", 0);
                this.append(sb, "environment", 2);
                this.append(sb, "List of ConfigurationItem in the target environment.", 3);
                this.append(sb, "", 0);
                this.append(sb, "environmentId", 2);
                this.append(sb, "Id of the environment used for the deployment.", 3);
                this.append(sb, "Expression: ${deployit.environmentId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "failIfNoStepsAreGenerated (Default: false)", 2);
                this.append(sb, "If a deployments leads no steps, fail the build.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generateManifestOnly (Default: false)", 2);
                this.append(sb, "Only the Manifest file will be generate. Do not copy files when generating Deployment package", 3);
                this.append(sb, "", 0);
                this.append(sb, "mappings", 2);
                this.append(sb, "List of the Mapping", 3);
                this.append(sb, "", 0);
                this.append(sb, "middlewareResources", 2);
                this.append(sb, "Additional resources such as Database, Apache plugin configuration, JMS Queues...", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "password used to connect to a remote server", 3);
                this.append(sb, "Expression: ${deployit.password}", 3);
                this.append(sb, "", 0);
                this.append(sb, "port (Default: 4516)", 2);
                this.append(sb, "Deployit Listen port", 3);
                this.append(sb, "Expression: ${deployit.port}", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "The maven project.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${project}", 3);
                this.append(sb, "", 0);
                this.append(sb, "remoteServerMode (Default: true)", 2);
                this.append(sb, "Tell the plugin it must connect to a remote Deployit Server. The following properties become mandatory: username, password, serverAddress, port. The default value is true. Note: the maven plugin does not support the local server mode anymore.", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverAddress", 2);
                this.append(sb, "Deployit server address", 3);
                this.append(sb, "Expression: ${deployit.server}", 3);
                this.append(sb, "", 0);
                this.append(sb, "testmode (Default: false)", 2);
                this.append(sb, "Activate the test mode, the steps are not executed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "timestampedVersion (Default: false)", 2);
                this.append(sb, "Use this attribute to add a timestamp to the version of the deployit package. by default, SNAPSHOT versions are automatically timestamped", 3);
                this.append(sb, "Expression: ${deployit.timestamp}", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "username used to connect to a remote server", 3);
                this.append(sb, "Expression: ${deployit.username}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "deployit:help", 0);
            this.append(sb, "Display help information on maven-deployit-plugin.\nCall\n\u00a0\u00a0mvn\u00a0deployit:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "import".equals(this.goal)) {
            this.append(sb, "deployit:import", 0);
            this.append(sb, "Import a Deployment Package into a Deployit server.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "deletePreviouslyDeployedDar (Default: false)", 2);
                this.append(sb, "Perform a skipped deployment before clean it.", 3);
                this.append(sb, "Expression: ${deployit.delete.previous.dar}", 3);
                this.append(sb, "", 0);
                this.append(sb, "deployableArtifacts", 2);
                this.append(sb, "Additional deployables artifacts", 3);
                this.append(sb, "", 0);
                this.append(sb, "environment", 2);
                this.append(sb, "List of ConfigurationItem in the target environment.", 3);
                this.append(sb, "", 0);
                this.append(sb, "environmentId", 2);
                this.append(sb, "Id of the environment used for the deployment.", 3);
                this.append(sb, "Expression: ${deployit.environmentId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "failIfNoStepsAreGenerated (Default: false)", 2);
                this.append(sb, "If a deployments leads no steps, fail the build.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generateManifestOnly (Default: false)", 2);
                this.append(sb, "Only the Manifest file will be generate. Do not copy files when generating Deployment package", 3);
                this.append(sb, "", 0);
                this.append(sb, "mappings", 2);
                this.append(sb, "List of the Mapping", 3);
                this.append(sb, "", 0);
                this.append(sb, "middlewareResources", 2);
                this.append(sb, "Additional resources such as Database, Apache plugin configuration, JMS Queues...", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "password used to connect to a remote server", 3);
                this.append(sb, "Expression: ${deployit.password}", 3);
                this.append(sb, "", 0);
                this.append(sb, "port (Default: 4516)", 2);
                this.append(sb, "Deployit Listen port", 3);
                this.append(sb, "Expression: ${deployit.port}", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "The maven project.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${project}", 3);
                this.append(sb, "", 0);
                this.append(sb, "remoteServerMode (Default: true)", 2);
                this.append(sb, "Tell the plugin it must connect to a remote Deployit Server. The following properties become mandatory: username, password, serverAddress, port. The default value is true. Note: the maven plugin does not support the local server mode anymore.", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverAddress", 2);
                this.append(sb, "Deployit server address", 3);
                this.append(sb, "Expression: ${deployit.server}", 3);
                this.append(sb, "", 0);
                this.append(sb, "testmode (Default: false)", 2);
                this.append(sb, "Activate the test mode, the steps are not executed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "timestampedVersion (Default: false)", 2);
                this.append(sb, "Use this attribute to add a timestamp to the version of the deployit package. by default, SNAPSHOT versions are automatically timestamped", 3);
                this.append(sb, "Expression: ${deployit.timestamp}", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "username used to connect to a remote server", 3);
                this.append(sb, "Expression: ${deployit.username}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

