/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.maven;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;

public class ConfigurationItem {
    private String type;
    private String label;
    private boolean addedToEnvironment = true;
    private final Map<String, Object> properties = Maps.newHashMap();

    public String getType() {
        return this.type;
    }

    public String getLabel() {
        if (this.label == null) {
            throw new IllegalStateException("Label cannot be null");
        }
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void addParameter(String name, Object value) {
        if ("addedToEnvironment".equals(name)) {
            this.addedToEnvironment = Boolean.parseBoolean(value.toString());
            return;
        }
        if ("type".equals(name)) {
            this.setType(value.toString());
            return;
        }
        if ("label".equals(name)) {
            this.label = value.toString();
            return;
        }
        this.properties.put(name, value);
    }

    public boolean isAddedToEnvironment() {
        return this.addedToEnvironment;
    }

    public void setAddedToEnvironment(boolean addedToEnvironment) {
        this.addedToEnvironment = addedToEnvironment;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public String toString() {
        Set<Map.Entry<String, Object>> entries = this.getProperties().entrySet();
        String properties = "{";
        boolean first = false;
        for (Map.Entry<String, Object> e : entries) {
            properties = properties + (first ? "," : "") + "\"" + e.getKey() + "\":\"" + e.getValue() + "\"";
            first = true;
        }
        properties = properties + "}";
        return String.format("repository.create(\"%s\",factory.configurationItem(\"%s\", %s))", this.getLabel(), this.getType(), properties);
    }
}

