/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.maven.packager;

import com.xebialabs.deployit.maven.packager.ApplicationDeploymentPackager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.artifact.Artifact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManifestPackager
implements ApplicationDeploymentPackager {
    private final File targetDirectory;
    private final String deploymentPackageName;
    private final Manifest manifest = new Manifest();
    private static final String DEPLOYMENT_PACKAGE_DIR = "deployment-package";

    public ManifestPackager(String artifactId, String version, File targetDirectory) {
        this.targetDirectory = new File(targetDirectory, DEPLOYMENT_PACKAGE_DIR + File.separator + artifactId + File.separator + version);
        this.targetDirectory.mkdirs();
        this.deploymentPackageName = artifactId + "/" + version;
        Attributes mainAttributes = this.manifest.getMainAttributes();
        mainAttributes.putValue("Manifest-Version", "1.0");
        mainAttributes.putValue("Deployit-Package-Format-Version", "1.1");
        mainAttributes.putValue("CI-Application", artifactId);
        mainAttributes.putValue("CI-Version", version);
    }

    @Override
    public void addMavenArtifact(Artifact artifact) {
        String ciType = null;
        String type = artifact.getType();
        if (type.compareToIgnoreCase("ear") == 0) {
            ciType = "Ear";
        } else if (type.compareToIgnoreCase("war") == 0) {
            ciType = "War";
        } else {
            System.out.println("Not supported type [" + ciType + "], skit it");
            return;
        }
        Map<String, Attributes> entries = this.manifest.getEntries();
        Attributes attributes = new Attributes();
        attributes.putValue("CI-Type", ciType);
        attributes.putValue("CI-Name", artifact.getArtifactId() + "-" + artifact.getVersion());
        entries.put(type + "/" + FilenameUtils.getName((String)artifact.getFile().getName()), attributes);
        try {
            FileUtils.copyFileToDirectory((File)artifact.getFile(), (File)new File(this.targetDirectory, type));
        }
        catch (IOException e) {
            throw new RuntimeException("Fail to copy of " + artifact.getFile() + " to " + new File(this.targetDirectory, type), e);
        }
    }

    @Override
    public void perform() {
        File meta_inf = new File(this.targetDirectory, "META-INF");
        meta_inf.mkdirs();
        File manifestFile = new File(meta_inf, "MANIFEST.MF");
        try {
            FileOutputStream fos = new FileOutputStream(manifestFile);
            this.manifest.write(fos);
            fos.close();
        }
        catch (IOException e) {
            new RuntimeException("perform failed", e);
        }
    }

    @Override
    public String getDeploymentPackageName() {
        return this.deploymentPackageName;
    }

    @Override
    public List<String> getCliCommands() {
        ArrayList<String> a = new ArrayList<String>();
        a.add("import location=" + this.targetDirectory);
        a.add("show");
        a.add("show_type");
        a.add("show_type DeploymentPackage");
        return a;
    }
}

