/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.maven.packager;

import com.xebialabs.deployit.maven.packager.ApplicationDeploymentPackager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.artifact.Artifact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CliPackager
implements ApplicationDeploymentPackager {
    private final String artifactId;
    private final String version;
    private final List<String> cliCommands = new ArrayList<String>();

    public CliPackager(String artifactId, String version) {
        this.artifactId = artifactId;
        this.version = version;
        this.addCommand("create Application label=\"" + artifactId + "\"");
        String createDeploymentPackage = "create DeploymentPackage label=\"" + artifactId + "\" application=\"" + artifactId + "\" version=\"" + version + "\"";
        this.addCommand(createDeploymentPackage);
    }

    @Override
    public void addMavenArtifact(Artifact artifact) {
        String ciType = null;
        String type = artifact.getType();
        if (type.compareToIgnoreCase("ear") == 0) {
            ciType = "Ear";
        } else if (type.compareToIgnoreCase("war") == 0) {
            ciType = "War";
        } else {
            System.out.println("Not supported type [" + ciType + "], skit it");
            return;
        }
        File archiveFile = artifact.getFile();
        if (archiveFile == null) {
            throw new RuntimeException("No file found for " + artifact);
        }
        String ciLabel = this.getDeploymentPackageName() + "/" + archiveFile.getName();
        this.addCommand("create " + ciType + " label=\"" + ciLabel + "\" name=\"" + FilenameUtils.getBaseName((String)archiveFile.getName()) + "\" location=\"" + archiveFile.getAbsolutePath() + "\"");
        this.addCommand("modify \"" + this.getDeploymentPackageName() + "\" deployableArtifacts+=\"" + ciLabel + "\"");
    }

    @Override
    public void perform() {
    }

    @Override
    public String getDeploymentPackageName() {
        return this.artifactId + " - " + this.version;
    }

    @Override
    public List<String> getCliCommands() {
        return this.cliCommands;
    }

    private void addCommand(String cmdLine) {
        this.cliCommands.add(cmdLine);
    }
}

