/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.maven;

import com.xebialabs.deployit.maven.AbstractDeployitMojo;
import com.xebialabs.deployit.maven.ConfigurationItem;
import com.xebialabs.deployit.maven.Module;
import com.xebialabs.deployit.maven.packager.ApplicationDeploymentPackager;
import com.xebialabs.deployit.maven.packager.CliPackager;
import com.xebialabs.deployit.maven.packager.ManifestPackager;
import java.util.ArrayList;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class DeployMojo
extends AbstractDeployitMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"deployit:deploy");
        if (this.environment == null) {
            throw new MojoExecutionException("Environment is empty");
        }
        this.startServer();
        ApplicationDeploymentPackager packager = this.useImportablePackage ? new ManifestPackager(this.artifactId, this.version, this.outputDirectory) : new CliPackager(this.artifactId, this.version);
        this.getLog().info((CharSequence)"create the main artifact");
        packager.addMavenArtifact(this.project.getArtifact());
        if (this.additionalArtifacts != null) {
            this.getLog().info((CharSequence)"create the additional artifacts");
            for (int i = 0; i < this.additionalArtifacts.length; ++i) {
                Module additionalArtifact = this.additionalArtifacts[i];
                Artifact additional = this.getArtifact(additionalArtifact);
                packager.addMavenArtifact(additional);
            }
        }
        packager.perform();
        this.interpret(packager.getCliCommands());
        this.getLog().info((CharSequence)"Create the environment");
        ArrayList<String> members = new ArrayList<String>();
        for (ConfigurationItem each : this.environment) {
            this.interpret(each.getCli());
            if (!each.isAddedToEnvironment()) continue;
            members.add(each.getLabel());
        }
        this.interpret("create Environment label=DefaultEnvironment");
        for (String member : members) {
            this.interpret("modify DefaultEnvironment members += \"" + member + "\" ");
        }
        if (this.middlewareResources != null) {
            this.getLog().info((CharSequence)"create Middleware Resources");
            for (ConfigurationItem ci : this.middlewareResources) {
                this.interpret(ci.getCli());
                this.interpret("modify \"" + packager.getDeploymentPackageName() + "\" middlewareResources+=\"" + ci.getLabel() + "\"");
            }
        }
        if (this.commands != null) {
            this.getLog().info((CharSequence)"Handle additional commands");
            for (String each : this.commands) {
                this.interpret(each);
            }
        }
        this.getLog().info((CharSequence)"Create the Deployment");
        StringBuilder depCmd = new StringBuilder("create Deployment ");
        depCmd.append("label=DefaultDeployment").append(' ');
        depCmd.append("source=").append('\"').append(packager.getDeploymentPackageName()).append('\"').append(' ');
        depCmd.append("target=DefaultEnvironment");
        this.interpret(depCmd.toString());
        if (this.mappings != null) {
            this.getLog().info((CharSequence)"create Mappings");
            for (ConfigurationItem ci : this.mappings) {
                this.interpret(ci.getCli());
                this.interpret("modify \"DefaultDeployment\" mappings+=\"" + ci.getLabel() + "\"");
            }
        }
        this.deployit();
        this.getLog().info((CharSequence)"end of deploy:deploy");
    }

    private Artifact getArtifact(Module module) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("-translateIntoPath- " + module));
        String key = ArtifactUtils.versionlessKey((String)module.getGroupId(), (String)module.getArtifactId());
        Artifact artifact = (Artifact)this.project.getArtifactMap().get(key);
        if (artifact == null) {
            throw new MojoExecutionException("The artifact " + key + " referenced in plugin as is not found the project dependencies");
        }
        return artifact;
    }
}

