/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.maven;

import com.xebia.ad.DeployItConfiguration;
import com.xebia.ad.ReleaseInfo;
import com.xebia.ad.Server;
import com.xebia.ad.cli.Interpreter;
import com.xebia.ad.setup.SetupDatabaseType;
import com.xebialabs.deployit.maven.ConfigurationItem;
import com.xebialabs.deployit.maven.Module;
import java.io.File;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDeployitMojo
extends AbstractMojo {
    protected MavenProject project;
    protected File outputDirectory;
    protected String artifactId;
    protected String version;
    protected String packaging;
    protected boolean testmode;
    protected File jeeArtifact;
    private int port;
    protected String[] commands;
    protected List<ConfigurationItem> middlewareResources;
    protected List<ConfigurationItem> mappings;
    protected List<ConfigurationItem> environment;
    protected Module[] additionalArtifacts;
    protected boolean useImportablePackage;
    protected Interpreter interpreter;
    protected static final String DEFAULT_ENVIRONMENT = "DefaultEnvironment";
    protected static final String DEFAULT_DEPLOYMENT = "DefaultDeployment";
    private static boolean SERVER_STARTED = false;

    protected void startServer() {
        if (!SERVER_STARTED) {
            this.getLog().info((CharSequence)"STARTING DEPLOYIT SERVER");
            DeployItConfiguration context = new DeployItConfiguration();
            context.setDatabaseType(SetupDatabaseType.HSQLDB);
            context.setDatabaseDriverClass(SetupDatabaseType.getDefaultDatabaseDriverClass((SetupDatabaseType)context.getDatabaseType()));
            context.setHibernateDialect(SetupDatabaseType.getHibernateDialect((SetupDatabaseType)context.getDatabaseType()));
            context.setDatabaseURL("jdbc:hsqldb:file:" + new File(this.outputDirectory, "/deployit.hdb").getPath() + ";shutdown=true");
            context.setDatabaseUsername(SetupDatabaseType.getDefaultUsername((SetupDatabaseType)context.getDatabaseType()));
            context.setDatabasePassword("");
            File deployitRepoDir = new File(this.outputDirectory, "deployit.repo");
            deployitRepoDir.mkdir();
            context.setApplicationRepositoryPath(deployitRepoDir.getPath());
            context.setHttpPort(this.port);
            context.setApplicationToDeployPath("importablePackages");
            context.setMinThreads(10);
            context.setMaxThreads(50);
            context.save();
            EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"ad-repository", (Map)context.getCreationalJPAProperties());
            emf.close();
            ReleaseInfo info = ReleaseInfo.getReleaseInfo();
            Server s = new Server(context, info);
            s.start();
            this.getLog().info((CharSequence)"STARTED DEPLOYIT SERVER");
            SERVER_STARTED = true;
        }
    }

    protected void interpret(String line) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Interpret [" + line + "]"));
        this.getInterpreter().interpretAndThrowExceptions(line);
    }

    protected void interpret(List<String> cliCommands) throws MojoExecutionException {
        for (String cmd : cliCommands) {
            this.interpret(cmd);
        }
    }

    protected Interpreter getInterpreter() throws MojoExecutionException {
        if (this.interpreter == null) {
            System.setProperty("cli.protocol", "http");
            ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext(new String[]{"/cli/unsecured/ad-cli-context.xml"});
            this.interpreter = (Interpreter)ctx.getBean("interpreter");
            if (this.interpreter == null) {
                throw new MojoExecutionException("Cannot find interpreter");
            }
            this.interpreter.afterPropertiesSet();
        }
        return this.interpreter;
    }

    protected void deployit() throws MojoExecutionException {
        this.getLog().info((CharSequence)" ");
        this.getLog().info((CharSequence)" ");
        this.getLog().info((CharSequence)"------------------------------------------------------------------");
        this.getLog().info((CharSequence)"--- DEPLOYIT CHANGE PLAN  ----------------------------------------");
        this.getLog().info((CharSequence)"------------------------------------------------------------------");
        this.interpret("changeplan steps");
        this.getLog().info((CharSequence)"------------------------------------------------------------------");
        this.getLog().info((CharSequence)"------------------------------------------------------------------");
        this.getLog().info((CharSequence)"------------------------------------------------------------------");
        this.getLog().info((CharSequence)" ");
        this.getLog().info((CharSequence)" ");
        if (this.testmode) {
            this.interpret("deployit_nosteps");
            this.interpret("export");
        } else {
            this.interpret("deployit");
        }
        this.interpret("changeplan changes");
    }
}

