/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.license.generator;

import java.io.OutputStream;
import java.io.PrintStream;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class LicenseGeneratorOptions {
    @Option(name="-contact", usage="The contact responsible for the license.", required=false)
    private String contact;
    @Option(name="-licensedTo", usage="The company the license will be for.", required=false)
    private String licensedTo;
    @Option(name="-expiresAfter", usage="The license will expire after this date yyyy-MM-dd", required=false)
    private String expiresAfter;
    @Option(name="-product", usage="The product the license is for. It is a required value. Possible values 'Deployit', 'XL Release', 'XL Deploy'.", required=false)
    private String product;
    @Option(name="-generateRepositoryId", usage="Generate a repository id.", required=false)
    private boolean generateRepositoryId;
    @Option(name="-repositoryId", usage="The repository id the license is for.", required=false)
    private String repositoryId;
    @Option(name="-maxNumberOfUsers", usage="The maximum number of users allowed by the license.", required=false)
    private String maxNumberOfUsers;
    @Option(name="-f", usage="The file to generate/check", required=false)
    private String file;
    @Option(name="-s", usage="The key size for a generated keypair (dev)", required=false)
    private int keySize;
    @Option(name="-help", required=false, usage="Prints this usage message")
    private boolean printUsage = false;
    @Option(name="-k", usage="Public/Private keypair", required=false)
    boolean generateKey;
    @Option(name="-g", usage="Generate license", required=false)
    boolean generateLicense;
    @Option(name="-v", usage="Validate license", required=false)
    boolean validateLicense;
    @Option(name="-version", usage="License version", required=false)
    private String licenseVersion;
    @Option(name="-maxNumberOfCis", usage="Licensed number of configuration items", required=false)
    private String maxNumberOfCis;
    @Option(name="-licensedPlugins", usage="Licensed plugins", required=false)
    private String licensedPlugins;
    @Option(name="-supportPolicy", usage="Support policy", required=false)
    private String supportPolicy;
    private Mode mode = Mode.GENERATE_LICENSE;

    public Mode getMode() {
        return this.mode;
    }

    public boolean isPrintUsage() {
        return this.printUsage;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public String getFile() {
        return this.file;
    }

    public String getExpiresAfter() {
        return this.expiresAfter;
    }

    public String getProduct() {
        return this.product;
    }

    public String getContact() {
        return this.contact;
    }

    public String getLicensedTo() {
        return this.licensedTo;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public String getMaxNumberOfUsers() {
        return this.maxNumberOfUsers;
    }

    public boolean isGenerateRepositoryId() {
        return this.generateRepositoryId;
    }

    public String getLicenseVersion() {
        return this.licenseVersion;
    }

    public String getMaxNumberOfCis() {
        return this.maxNumberOfCis;
    }

    public String getLicensedPlugins() {
        return this.licensedPlugins;
    }

    public String getSupportPolicy() {
        return this.supportPolicy;
    }

    public static LicenseGeneratorOptions parseCommandLine(String[] args) {
        LicenseGeneratorOptions options = new LicenseGeneratorOptions();
        CmdLineParser parser = new CmdLineParser((Object)options);
        try {
            parser.parseArgument(args);
            if (options.isPrintUsage()) {
                LicenseGeneratorOptions.printUsage(parser, System.out);
                return null;
            }
            options.validate(parser);
        }
        catch (CmdLineException e) {
            LicenseGeneratorOptions.printUsage(parser, System.err);
            System.err.println(e.getMessage());
            return null;
        }
        return options;
    }

    private static void printUsage(CmdLineParser parser, PrintStream stream) {
        System.out.println("license-generator arguments...");
        parser.printUsage((OutputStream)stream);
    }

    private void validate(CmdLineParser parser) throws CmdLineException {
        if (this.generateKey) {
            if (this.keySize != 1024 && this.keySize != 2048) {
                throw new CmdLineException(parser, "Key size must be 1024 or 2048.");
            }
            this.mode = Mode.GENERATE_KEYPAIR;
        } else if (this.generateLicense) {
            this.validateOptionIsNotEmpty(parser, this.product, "Product");
            this.validateOptionIsNotEmpty(parser, this.contact, "Contact");
            this.validateOptionIsNotEmpty(parser, this.licensedTo, "Licensed to");
            this.validateOptionIsNotEmpty(parser, this.expiresAfter, "Expires after");
            this.validateOptionIsNotEmpty(parser, this.file, "File ");
            if (this.licenseVersion != null && !this.licenseVersion.equals("1") && !this.licenseVersion.equals("2")) {
                throw new CmdLineException(parser, "Unsupported license version");
            }
            this.mode = Mode.GENERATE_LICENSE;
        } else if (this.validateLicense) {
            this.validateOptionIsNotEmpty(parser, this.file, "File ");
            this.mode = Mode.VALIDATE_KEY;
        } else {
            throw new CmdLineException(parser, "Please use one of the validate or generate modes.");
        }
    }

    private void validateOptionIsNotEmpty(CmdLineParser parser, String optionValue, String optionName) throws CmdLineException {
        if (optionValue == null || optionValue.trim().isEmpty()) {
            throw new CmdLineException(parser, optionName + " cannot be empty");
        }
    }

    public static enum Mode {
        GENERATE_LICENSE,
        GENERATE_KEYPAIR,
        VALIDATE_KEY;

    }
}

