/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.license.generator;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.xebialabs.license.InvalidLicenseException;
import com.xebialabs.license.License;
import com.xebialabs.license.LicenseProperty;
import com.xebialabs.license.LicenseReader;
import com.xebialabs.license.LicenseVersion1;
import com.xebialabs.license.LicenseVersion2;
import com.xebialabs.license.UnableToValidateLicenseException;
import com.xebialabs.license.generator.LicenseGeneratorOptions;
import com.xebialabs.license.generator.LineBreakingOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Map;
import java.util.UUID;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.HexEncoder;

public class LicenseGenerator {
    private static final String PRIV_KEY = "3082014b0201003082012c06072a8648ce3804013082011f02818100fd7f53811d75122952df4a9c2eece4e7f611b7523cef4400c31e3f80b6512669455d402251fb593d8d58fabfc5f5ba30f6cb9b556cd7813b801d346ff26660b76b9950a5a49f9fe8047b1022c24fbba9d7feb7c61bf83b57e7c6a8a6150f04fb83f6d3c51ec3023554135a169132f675f3ae2b61d72aeff22203199dd14801c70215009760508f15230bccb292b982a2eb840bf0581cf502818100f7e1a085d69b3ddecbbcab5c36b857b97994afbbfa3aea82f9574c0b3d0782675159578ebad4594fe67107108180b449167123e84c281613b7cf09328cc8a6e13c167a8b547c8d28e0a3ae1e2bb3a675916ea37f0bfa213562f1fb627a01243bcca4f1bea8519089a883dfe15ae59f06928b665e807b552564014c3bfecf492a041602140480cc8eb9735d2d83f0a5f4ffd15aa3c76d7298";

    private static void writeKey(Key key) throws IOException {
        byte[] bytes = key.getEncoded();
        HexEncoder hexit = new HexEncoder();
        hexit.encode(bytes, 0, bytes.length, (OutputStream)System.out);
    }

    private static void genKeyPair(int keySize) throws IOException, GeneralSecurityException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("DSA", "BC");
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG", "BC");
        keyGen.initialize(keySize, random);
        KeyPair pair = keyGen.generateKeyPair();
        PrivateKey priv = pair.getPrivate();
        System.out.print("Private key: ");
        LicenseGenerator.writeKey(priv);
        PublicKey pub = pair.getPublic();
        System.out.print("Public key : ");
        LicenseGenerator.writeKey(pub);
    }

    private static void writeSigned(License license, String outFile) throws IOException, GeneralSecurityException {
        try (FileOutputStream signedFile = new FileOutputStream(outFile);){
            LicenseGenerator.writeSigned(license, signedFile);
        }
    }

    private static void writeSigned(License license, OutputStream signedFile) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException, IOException, InvalidKeyException, SignatureException {
        String lineSeparator = System.getProperty("line.separator");
        KeyFactory kf = KeyFactory.getInstance("DSA", "BC");
        PrivateKey privateKey = kf.generatePrivate(new PKCS8EncodedKeySpec(LicenseReader.readKey((String)PRIV_KEY)));
        Signature dsa = Signature.getInstance("SHA1withDSA", "BC");
        dsa.initSign(privateKey);
        byte[] data = license.toLicenseContent().getBytes(LicenseReader.LICENSE_FILE_ENCODING);
        dsa.update(data);
        byte[] signature = dsa.sign();
        String version = license.getLicenseVersion();
        String preamble = version.equals("1") ? "--- License V1 ---" : "--- License ---";
        signedFile.write(preamble.getBytes(LicenseReader.LICENSE_FILE_ENCODING));
        signedFile.write(lineSeparator.getBytes(LicenseReader.LICENSE_FILE_ENCODING));
        signedFile.write(data);
        signedFile.write(String.format("--- Signature (%s) ---", dsa.getAlgorithm()).getBytes(LicenseReader.LICENSE_FILE_ENCODING));
        signedFile.write(lineSeparator.getBytes(LicenseReader.LICENSE_FILE_ENCODING));
        HexEncoder hexit = new HexEncoder();
        hexit.encode(signature, 0, signature.length, (OutputStream)new LineBreakingOutputStream(signedFile));
        signedFile.write(lineSeparator.getBytes(LicenseReader.LICENSE_FILE_ENCODING));
        signedFile.write("--- End of Signature ---".getBytes(LicenseReader.LICENSE_FILE_ENCODING));
        signedFile.write(lineSeparator.getBytes(LicenseReader.LICENSE_FILE_ENCODING));
    }

    public static boolean validateLicense(String licenseFilename) throws IOException {
        try {
            License license = LicenseReader.readLicense((File)new File(licenseFilename));
            System.out.printf(license.toString(), new Object[0]);
            return true;
        }
        catch (InvalidLicenseException e) {
            System.out.println("License invalid: " + e.getMessage());
        }
        catch (UnableToValidateLicenseException e) {
            System.out.println("License check failed: " + e.getMessage());
        }
        return false;
    }

    public static void genLicense(String licenseVersion, String file, Multimap<LicenseProperty, String> licenseProperties) throws IOException, GeneralSecurityException {
        LicenseVersion1 license;
        if ("1".equals(licenseVersion)) {
            license = new LicenseVersion1(licenseProperties);
        } else if (Strings.isNullOrEmpty((String)licenseVersion) || "2".equals(licenseVersion)) {
            licenseProperties.put((Object)LicenseProperty.LICENSE_VERSION, (Object)"2");
            license = new LicenseVersion2(licenseProperties);
        } else {
            throw new InvalidLicenseException(String.format("Unsupported license version %s", licenseVersion));
        }
        LicenseGenerator.writeSigned((License)license, file);
    }

    public static void main(String[] args) throws IOException, GeneralSecurityException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        LicenseGeneratorOptions options = LicenseGeneratorOptions.parseCommandLine(args);
        if (options == null) {
            return;
        }
        switch (options.getMode()) {
            case GENERATE_KEYPAIR: {
                LicenseGenerator.genKeyPair(options.getKeySize());
                break;
            }
            case GENERATE_LICENSE: {
                Multimap<LicenseProperty, String> licenseProperties = LicenseGenerator.getLicenseProperties(options);
                LicenseGenerator.genLicense(options.getLicenseVersion(), options.getFile(), licenseProperties);
                break;
            }
            case VALIDATE_KEY: {
                LicenseGenerator.validateLicense(options.getFile());
            }
        }
    }

    private static Multimap<LicenseProperty, String> getLicenseProperties(LicenseGeneratorOptions options) {
        ArrayListMultimap licenseProperties = ArrayListMultimap.create();
        licenseProperties.put((Object)LicenseProperty.PRODUCT, (Object)options.getProduct());
        licenseProperties.put((Object)LicenseProperty.LICENSED_TO, (Object)options.getLicensedTo());
        licenseProperties.put((Object)LicenseProperty.CONTACT, (Object)options.getContact());
        licenseProperties.put((Object)LicenseProperty.REPOSITORY_ID, (Object)LicenseGenerator.getRepositoryId(options));
        licenseProperties.put((Object)LicenseProperty.EXPIRES_AFTER, (Object)options.getExpiresAfter());
        licenseProperties.put((Object)LicenseProperty.MAX_NUMBER_OF_USERS, (Object)options.getMaxNumberOfUsers());
        if (options.getMaxNumberOfCis() != null) {
            licenseProperties.putAll((Object)LicenseProperty.MAX_NUMBER_OF_CIS, options.getMaxNumberOfCis());
        }
        if (options.getLicensedPlugin() != null) {
            licenseProperties.putAll((Object)LicenseProperty.LICENSED_PLUGINS, options.getLicensedPlugin());
        }
        licenseProperties.put((Object)LicenseProperty.SUPPORT_POLICY, (Object)options.getSupportPolicy());
        return Multimaps.filterEntries((Multimap)licenseProperties, (Predicate)new Predicate<Map.Entry<LicenseProperty, String>>(){

            public boolean apply(Map.Entry<LicenseProperty, String> input) {
                return input.getValue() != null && !input.getValue().trim().isEmpty();
            }
        });
    }

    private static String getRepositoryId(LicenseGeneratorOptions options) {
        String repositoryId = options.getRepositoryId();
        if (repositoryId == null && options.isGenerateRepositoryId()) {
            repositoryId = UUID.randomUUID().toString();
        }
        return repositoryId;
    }
}

