/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.license.generator;

import java.io.IOException;
import java.io.OutputStream;

public class LineBreakingOutputStream
extends OutputStream {
    private OutputStream wrappee;
    private int written;
    private final int maxWidth;
    private byte[] lineSeparator;

    public LineBreakingOutputStream(OutputStream toWrap) {
        this(toWrap, 80, System.getProperty("line.separator"));
    }

    public LineBreakingOutputStream(OutputStream toWrap, int maxWidth, String lineSeparator) {
        this.wrappee = toWrap;
        this.maxWidth = maxWidth;
        this.lineSeparator = lineSeparator.getBytes();
        this.written = 0;
    }

    @Override
    public void write(int b) throws IOException {
        if (b == 10 || b == 13) {
            this.written = 0;
        }
        if (this.written >= this.maxWidth) {
            this.wrappee.write(this.lineSeparator);
            this.written = 0;
        }
        this.wrappee.write(b);
        ++this.written;
    }

    @Override
    public void flush() throws IOException {
        this.wrappee.flush();
    }
}

