/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.license.v1;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.xebialabs.license.InvalidLicenseException;
import java.util.Set;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class License {
    public static final String VERSION = "1";
    public static final String LICENSE_V1_PREAMBLE = "--- License V1 ---";
    public static final String LP_LICENSED_TO = "Licensed to";
    public static final String LP_CONTACT = "Contact";
    public static final String LP_EXPIRES_AFTER = "Expires after";
    public static final String LP_PRODUCT = "Product";
    public static final String LP_REPOSITORY_ID = "Repository id";
    public static final String PRODUCT_DEPLOYIT = "XL Deploy";
    public static final String PRODUCT_OLD_DEPLOYIT = "Deployit";
    public static final String PRODUCT_XL_RELEASE = "XL Release";
    public static final Set<String> PRODUCTS = Sets.newHashSet((Object[])new String[]{"XL Deploy", "XL Release", "Deployit"});
    public static final DateTimeFormatter LICENSE_DATE_FORMAT = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    protected LocalDate expiresAfter;
    protected String licensedTo;
    protected String contact;
    protected String repositoryId;
    protected String product;

    public void validate() {
        Preconditions.checkNotNull((Object)this.getExpiresAfter(), (Object)"expiresAfter cannot be null");
        Preconditions.checkNotNull((Object)this.licensedTo, (Object)"licensedTo cannot be null");
        Preconditions.checkArgument((!this.licensedTo.trim().isEmpty() ? 1 : 0) != 0, (Object)"licensedTo cannot be empty");
        Preconditions.checkNotNull((Object)this.contact, (Object)"contact cannot be null");
        Preconditions.checkArgument((!this.contact.trim().isEmpty() ? 1 : 0) != 0, (Object)"contact cannot be empty");
        Preconditions.checkArgument((boolean)PRODUCTS.contains(this.getProduct()), (Object)String.format("product should be one of: %s got '%s'", PRODUCTS, this.getProduct()));
    }

    public String getLicenseVersion() {
        return VERSION;
    }

    public LocalDate getExpiresAfter() {
        return this.expiresAfter;
    }

    public String getLicensedTo() {
        return this.licensedTo;
    }

    public String getContact() {
        return this.contact;
    }

    public String getProduct() {
        return this.product;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public boolean setProperty(String key, String value) {
        if (!LP_REPOSITORY_ID.equals(key)) {
            Preconditions.checkNotNull((Object)value, (Object)String.format("Cannot set %s to null", key));
        }
        String string = value = value != null ? value.trim() : null;
        if (LP_LICENSED_TO.equals(key)) {
            this.licensedTo = value;
        } else if (LP_CONTACT.equals(key)) {
            this.contact = value;
        } else if (LP_EXPIRES_AFTER.equals(key)) {
            this.expiresAfter = License.parseDate(value);
        } else if (LP_PRODUCT.equals(key)) {
            this.product = value;
        } else if (LP_REPOSITORY_ID.equals(key)) {
            this.repositoryId = value;
        } else {
            return false;
        }
        return true;
    }

    public Object getProperty(String key) {
        if (LP_LICENSED_TO.equals(key)) {
            return this.getLicensedTo();
        }
        if (LP_CONTACT.equals(key)) {
            return this.getContact();
        }
        if (LP_EXPIRES_AFTER.equals(key)) {
            return this.getExpiresAfter();
        }
        if (LP_PRODUCT.equals(key)) {
            return this.getProduct();
        }
        if (LP_REPOSITORY_ID.equals(key)) {
            return this.getRepositoryId();
        }
        throw new IllegalArgumentException(String.format("Unknown property '%s'", key));
    }

    private static LocalDate parseDate(String date) {
        try {
            return LocalDate.parse((String)date, (DateTimeFormatter)LICENSE_DATE_FORMAT);
        }
        catch (Exception e) {
            throw new InvalidLicenseException(String.format("Unable to parse date '%s'", date));
        }
    }

    public String toLicenseContent() {
        String productString = this.product == null ? "" : String.format("%s: %s%n", LP_PRODUCT, this.getProduct());
        String serverString = this.repositoryId == null ? "" : String.format("%s: %s%n", LP_REPOSITORY_ID, this.getRepositoryId());
        return String.format("%s%s: %s%n%s: %s%n%s%s: %s%n", productString, LP_LICENSED_TO, this.getLicensedTo(), LP_CONTACT, this.getContact(), serverString, LP_EXPIRES_AFTER, LICENSE_DATE_FORMAT.print((ReadablePartial)this.getExpiresAfter()));
    }

    public String toString() {
        String serverString = this.repositoryId == null ? "" : String.format("Repository id : %s%n", this.getRepositoryId());
        return String.format("Product       : %s%nLicensed to   : %s%nContact       : %s%n%sExpires After : %s%n", this.getProduct(), this.getLicensedTo(), this.getContact(), serverString, LICENSE_DATE_FORMAT.print((ReadablePartial)this.getExpiresAfter()));
    }
}

