/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.license;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.xebialabs.license.InvalidLicenseException;
import com.xebialabs.license.LicenseProperty;
import com.xebialabs.license.LicensePropertyType;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public abstract class License {
    public static final String PRODUCT_DEPLOYIT = "XL Deploy";
    public static final String PRODUCT_OLD_DEPLOYIT = "Deployit";
    public static final String PRODUCT_XL_RELEASE = "XL Release";
    public static final Set<String> PRODUCTS = Sets.newHashSet((Object[])new String[]{"XL Deploy", "XL Release", "Deployit"});
    static final DateTimeFormatter LICENSE_DATE_FORMAT = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    private Multimap<LicenseProperty, String> values;

    protected License(Multimap<LicenseProperty, String> values) {
        this.values = ArrayListMultimap.create(this.filterLicenseProperties(values));
        this.validateLicenseFormat();
    }

    public abstract List<LicenseProperty> getLicenseProperties();

    public abstract String getLicenseVersion();

    private Multimap<LicenseProperty, String> filterLicenseProperties(Multimap<LicenseProperty, String> values) {
        return Multimaps.filterEntries(values, (Predicate)new Predicate<Map.Entry<LicenseProperty, String>>(){

            public boolean apply(Map.Entry<LicenseProperty, String> input) {
                return input.getValue() != null && !input.getValue().trim().isEmpty();
            }
        });
    }

    protected void validateProperties() {
        for (LicenseProperty property : this.getLicenseProperties()) {
            this.validateRequired(property);
            this.validateValueFormat(property);
        }
    }

    private void validateRequired(LicenseProperty property) {
        if (property.isRequired() && !this.hasLicenseProperty(property)) {
            throw new InvalidLicenseException(this.emptyErrorMessage(property));
        }
    }

    private void validateProduct() {
        String product = this.getStringValue(LicenseProperty.PRODUCT);
        if (!PRODUCTS.contains(product)) {
            throw new InvalidLicenseException(String.format("product should be one of: %s got '%s'", PRODUCTS, product));
        }
    }

    private void validateValueFormat(LicenseProperty property) {
        switch (property.getType()) {
            case DATE: {
                this.parseDateAndValidate(property);
                break;
            }
            case MAP_STRING_INTEGER: {
                this.parseMapOfStringIntegerAndValidate(property);
                break;
            }
            case LIST_OF_STRINGS: {
                this.getListValue(property);
            }
        }
    }

    public void validateLicenseFormat() {
        this.validateProperties();
        this.validateProduct();
    }

    public boolean isDateExpired() {
        LocalDate localDateValue = this.getLocalDateValue(LicenseProperty.EXPIRES_AFTER);
        if (localDateValue == null) {
            return false;
        }
        return LocalDate.now().isAfter((ReadablePartial)localDateValue);
    }

    public String getStringValue(LicenseProperty key) {
        Collection parts = this.values.get((Object)key);
        if (parts.isEmpty()) {
            return null;
        }
        return Joiner.on((String)",").skipNulls().join((Iterable)parts);
    }

    public LocalDate getLocalDateValue(LicenseProperty key) {
        return this.parseDateAndValidate(key);
    }

    public Map<String, Integer> getMapValue(LicenseProperty key) {
        return this.parseMapOfStringIntegerAndValidate(key);
    }

    public List<String> getListValue(LicenseProperty property) {
        return Lists.newArrayList((Iterable)this.values.get((Object)property));
    }

    public boolean hasLicenseProperty(LicenseProperty key) {
        return this.values.containsKey((Object)key);
    }

    private LocalDate parseDateAndValidate(LicenseProperty property) {
        String propertyValue = this.getStringValue(property);
        if (!Strings.isNullOrEmpty((String)propertyValue)) {
            try {
                return LocalDate.parse((String)propertyValue, (DateTimeFormatter)LICENSE_DATE_FORMAT);
            }
            catch (Exception e) {
                throw new InvalidLicenseException(this.createErrorMessage(property, propertyValue));
            }
        }
        return null;
    }

    private Map<String, Integer> parseMapOfStringIntegerAndValidate(LicenseProperty property) {
        Collection values = this.values.get((Object)property);
        if (values == null) {
            return Maps.newHashMap();
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (String pair : values) {
            try {
                String[] pairStringInt = pair.trim().split("=");
                Integer intValue = Integer.parseInt(pairStringInt[1].trim());
                String stringValue = pairStringInt[0].trim();
                result.put(stringValue, intValue);
            }
            catch (Exception e) {
                throw new InvalidLicenseException(this.createErrorMessage(property, values.toString()));
            }
        }
        return result;
    }

    private String createErrorMessage(LicenseProperty property, String propertyValue) {
        return String.format("Unable to parse '%s' '%s'", property.getName().toLowerCase(), propertyValue);
    }

    private String emptyErrorMessage(LicenseProperty property) {
        return String.format("'%s' cannot be empty", property.getName().toLowerCase());
    }

    private String formatAll(String format) {
        return this.formatAllWithProperties(format, this.getLicenseProperties());
    }

    private String formatAllWithProperties(String template, List<LicenseProperty> properties) {
        StringBuilder result = new StringBuilder();
        for (LicenseProperty property : properties) {
            if (!this.hasLicenseProperty(property)) continue;
            String propertyString = property.getType() == LicensePropertyType.LIST_OF_STRINGS || property.getType() == LicensePropertyType.MAP_STRING_INTEGER ? this.formatMultiValueProperty(property, template, ",") : this.formatStringProperty(property, template);
            result.append(propertyString);
        }
        return result.toString();
    }

    public String toLicenseContent() {
        return this.formatAll("%s: %s\n");
    }

    public String toString() {
        return this.formatAll("%-" + String.valueOf(LicenseProperty.getLongerNameLength()) + "s: %s\n");
    }

    private String formatStringProperty(LicenseProperty licenseProperty, String template) {
        String value = this.getStringValue(licenseProperty);
        return String.format(template, licenseProperty.getName(), value);
    }

    private String formatMultiValueProperty(LicenseProperty licenseProperty, String template, String separator) {
        Collection strings = this.values.get((Object)licenseProperty);
        StringBuilder result = new StringBuilder();
        for (String value : strings) {
            result.append(String.format(template, licenseProperty.getName(), value));
        }
        return result.toString();
    }
}

