/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.jbossas.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer;
import com.xebialabs.deployit.plugin.jbossas.step.JbossasStepBase;
import com.xebialabs.deployit.plugin.jbossas.support.XPathUtils;
import org.apache.commons.lang.StringUtils;

public class CheckAjpPortStep
extends JbossasStepBase {
    static final String XPATH_JBOSS4 = "/Server/Service/Connector[@protocol='AJP/1.3']/@port";
    static final String XPATH_JBOSS5 = "//bean[@class='org.jboss.services.binding.ServiceBindingMetadata'][property='jboss.web:service=WebServer']/property[@name='port']";
    static final String XPATH_JBOSS6 = "//bean[@class='org.jboss.services.binding.ServiceBindingMetadata'][property='jboss.web:service=WebServer' and property='AjpConnector']/property[@name='port']";

    public CheckAjpPortStep(JbossasServer server) {
        super(server);
        this.setDescription("Check the AJP port of the jboss server " + (Object)((Object)server));
    }

    public boolean execute(StepExecutionContext ctx) {
        switch (this.server.getVersion()) {
            case JBOSSAS_40: {
                return this.checkNamingPortJBoss4(ctx);
            }
            case JBOSSAS_50: {
                return this.checkNamingPortJBoss5(ctx);
            }
            case JBOSSAS_60: {
                return this.checkNamingPortJBoss6(ctx);
            }
        }
        ctx.logOutput("Implementation of the step not done for this version" + (Object)((Object)this.server.getVersion()));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkNamingPortJBoss6(StepExecutionContext ctx) {
        HostSession s = this.server.connectToAdminHost();
        try {
            String fileSep = this.server.getHost().getFileSeparator();
            String configurationFilePath = (this.server.getInstanceDirPath() + "/conf/bindingservice.beans/META-INF/bindings-jboss-beans.xml").replace("/", fileSep);
            HostFile configuration = s.getFile(configurationFilePath);
            ctx.logOutput("Configuration file is " + configuration);
            String nodes = XPathUtils.searchStringWithXPath(configuration, XPATH_JBOSS6);
            if (StringUtils.isBlank((String)nodes)) {
                ctx.logError("//bean[@class='org.jboss.services.binding.ServiceBindingMetadata'][property='jboss.web:service=WebServer' and property='AjpConnector']/property[@name='port'] gives no candidates");
            } else {
                this.server.setAjpPort(Integer.parseInt(nodes.trim()));
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            ctx.logError("XML/XPAth Exception", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            s.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkNamingPortJBoss5(StepExecutionContext ctx) {
        HostSession s = this.server.connectToAdminHost();
        try {
            String fileSep = this.server.getHost().getFileSeparator();
            String configurationFilePath = (this.server.getInstanceDirPath() + "/conf/bindingservice.beans/META-INF/bindings-jboss-beans.xml").replace("/", fileSep);
            HostFile configuration = s.getFile(configurationFilePath);
            ctx.logOutput("Configuration file is " + configuration);
            String nodes = XPathUtils.searchStringWithXPath(configuration, XPATH_JBOSS5);
            if (StringUtils.isBlank((String)nodes)) {
                ctx.logError("//bean[@class='org.jboss.services.binding.ServiceBindingMetadata'][property='jboss.web:service=WebServer']/property[@name='port'] gives no candidates");
            } else {
                this.server.setAjpPort(Integer.parseInt(nodes.trim()) - 71);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            ctx.logError("XML/XPAth Exception", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            s.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkNamingPortJBoss4(StepExecutionContext ctx) {
        HostSession s = this.server.connectToAdminHost();
        try {
            String fileSep = this.server.getHost().getFileSeparator();
            HostFile configuration = s.getFile(this.server.getDeployDirPath() + fileSep + "jboss-web.deployer" + fileSep + "server.xml");
            String nodes = XPathUtils.searchStringWithXPath(configuration, XPATH_JBOSS4);
            if (StringUtils.isBlank((String)nodes)) {
                ctx.logError("/Server/Service/Connector[@protocol='AJP/1.3']/@port gives no candidates");
            } else {
                this.server.setAjpPort(Integer.parseInt(nodes.trim()));
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            ctx.logError("XML/XPAth Exception", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            s.close();
        }
    }
}

