package com.xebialabs.deployit.plugin.jbossas.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.StepExecutionContextCallbackHandler;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer;
import org.apache.commons.lang.StringUtils;

/**
 * Stop a {@link com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer} by invoking the configured command.
 */
@SuppressWarnings("serial")
public class JbossasStopServerStep extends JbossasStepBase {

	public JbossasStopServerStep(JbossasServer server) {
		super(server);
		setDescription("Stop JBoss server " + server);
	}

	public boolean execute(StepExecutionContext ctx) {
		HostSession s = server.connectToAdminHost();
		try {
			String stopCommand = server.getStopCommand();
			if (StringUtils.isBlank(stopCommand)) {
				//shutdown.sh -s jnp://localhost:1099
				stopCommand = server.getShutdownCommand() + " -s jnp://" + server.getHost().getAddress() + ":" + server.getControlPort();
			}
			ctx.logOutput("Stop command is: " + stopCommand);
			String[] stopCommandLine = StringUtils.split(stopCommand);
			int res = s.execute(new StepExecutionContextCallbackHandler(ctx), stopCommandLine);
			return res == 0;
		} finally {
			s.close();
		}
	}

}
