package com.xebialabs.deployit.plugin.jbossas.step;

import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.StepExecutionContextCallbackHandler;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer;
import org.apache.commons.lang.StringUtils;

/**
 * Start a {@link com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer} by invoking the configured command.
 */
@SuppressWarnings("serial")
public class JbossasStartServerStep extends JbossasStepBase {

	public JbossasStartServerStep(JbossasServer server) {
		super(server);
		setDescription("Start JBoss server " + server);
	}

	public boolean execute(StepExecutionContext ctx) {

		HostSession s = server.connectToAdminHost();
		try {
			String startCommand = server.getStartCommand();
			if (StringUtils.isBlank(startCommand)) {
				throw new ResolutionException("No start command specified in the server");
			}
			ctx.logOutput("Start command is: " + startCommand);
			String[] startCommandLine = StringUtils.split(startCommand);
			int res = s.execute(new StepExecutionContextCallbackHandler(ctx), startCommandLine);
			return res == 0;
		} finally {
			s.close();
		}
	}
}
