/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.jbossas.step;

import com.xebialabs.deployit.ci.artifact.Ear;
import com.xebialabs.deployit.ci.artifact.EjbJar;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.hostsession.HostFileInputStreamTransformer;
import com.xebialabs.deployit.hostsession.LenientTemplateResolvingArchiveHostFileInputTransformer;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasArtifactServerMapping;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasWarMapping;
import org.apache.commons.lang.StringUtils;

import java.util.Map;

@SuppressWarnings("serial")
public abstract class JbossasDeploymentStepBase extends JbossasStepBase {

	protected NamedDeployableArtifact artifact;

	private JbossasArtifactServerMapping mapping;

	protected JbossasDeploymentStepBase(JbossasServer server, NamedDeployableArtifact artifact, JbossasArtifactServerMapping mapping) {
		super(server);
		this.artifact = artifact;
		this.mapping = mapping;
	}

	protected String getArtifactTargetFileName() {
		String targetFileName = artifact.getName();
		if (artifact instanceof Ear) {
			targetFileName += ".ear";
		} else if (artifact instanceof War) {
			targetFileName += ".war";
			if (mapping != null && mapping instanceof JbossasWarMapping) {
				JbossasWarMapping warMapping = (JbossasWarMapping) mapping;
				if (StringUtils.isNotBlank(warMapping.getContextRoot())) {
					targetFileName = warMapping.getContextRoot() + ".war";
				}
			}
		} else if (artifact instanceof EjbJar) {
			targetFileName += ".jar";
		} else {
			throw new IllegalArgumentException("Artifact " + artifact + " is neither an EAR, a WAR nor an EJB JAR");
		}
		return targetFileName;
	}

	protected HostFileInputStreamTransformer getTransformer() {
		if (mapping == null)
			return null;
		final Map<String, String> keyValueMap = mapping.getKeyValueMap();
		if (keyValueMap.isEmpty())
			return null;
		return new LenientTemplateResolvingArchiveHostFileInputTransformer(keyValueMap, mapping.getPlaceholderFormat());
	}
}
