package com.xebialabs.deployit.plugin.jbossas.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer;
import com.xebialabs.deployit.plugin.jbossas.support.XPathUtils;
import org.apache.commons.lang.StringUtils;

@SuppressWarnings("serial")
public class CheckAjpPortStep extends JbossasStepBase {
	static final String XPATH_JBOSS4 = "/Server/Service/Connector[@protocol='AJP/1.3']/@port";
	static final String XPATH_JBOSS5 = "//bean[@class='org.jboss.services.binding.ServiceBindingMetadata'][property='jboss.web:service=WebServer']/property[@name='port']";
	static final String XPATH_JBOSS6 = "//bean[@class='org.jboss.services.binding.ServiceBindingMetadata'][property='jboss.web:service=WebServer' and property='AjpConnector']/property[@name='port']";

	public CheckAjpPortStep(JbossasServer server) {
		super(server);
		setDescription("Check the AJP port of the jboss server " + server);
	}

	public boolean execute(StepExecutionContext ctx) {
		switch (server.getVersion()) {
			case JBOSSAS_40:
				return checkNamingPortJBoss4(ctx);
			case JBOSSAS_50:
				return checkNamingPortJBoss5(ctx);
			case JBOSSAS_60:
				return checkNamingPortJBoss6(ctx);
			default:
				ctx.logOutput("Implementation of the step not done for this version" + server.getVersion());
				return true;
		}
	}

	private boolean checkNamingPortJBoss6(StepExecutionContext ctx) {
		//itest/conf/bindingservice.beans/META-INF/bindings-jboss-beans.xml
		// AJP Port = WebPort - 71 cf bindings-jboss-beans.xml
		HostSession s = server.connectToAdminHost();
		try {
			String fileSep = server.getHost().getFileSeparator();
			final String configurationFilePath = (server.getInstanceDirPath() + "/conf/bindingservice.beans/META-INF/bindings-jboss-beans.xml").replace("/", fileSep);
			HostFile configuration = s.getFile(configurationFilePath);
			ctx.logOutput("Configuration file is " + configuration);
			String nodes = XPathUtils.searchStringWithXPath(configuration, XPATH_JBOSS6);
			if (StringUtils.isBlank(nodes)) {
				ctx.logError(XPATH_JBOSS6 + " gives no candidates");
			} else {
				server.setAjpPort(Integer.parseInt(nodes.trim()));
			}
			return true;
		}
		catch (Exception e) {
			ctx.logError("XML/XPAth Exception", e);
			return false;
		} finally {
			s.close();
		}

	}

	private boolean checkNamingPortJBoss5(StepExecutionContext ctx) {
		//itest/conf/bindingservice.beans/META-INF/bindings-jboss-beans.xml
		// AJP Port = WebPort - 71 cf bindings-jboss-beans.xml
		HostSession s = server.connectToAdminHost();
		try {
			String fileSep = server.getHost().getFileSeparator();
			final String configurationFilePath = (server.getInstanceDirPath() + "/conf/bindingservice.beans/META-INF/bindings-jboss-beans.xml").replace("/", fileSep);
			HostFile configuration = s.getFile(configurationFilePath);
			ctx.logOutput("Configuration file is " + configuration);
			String nodes = XPathUtils.searchStringWithXPath(configuration, XPATH_JBOSS5);
			if (StringUtils.isBlank(nodes)) {
				ctx.logError(XPATH_JBOSS5 + " gives no candidates");
			} else {
				server.setAjpPort(Integer.parseInt(nodes.trim()) - 71);
			}
			return true;
		}
		catch (Exception e) {
			ctx.logError("XML/XPAth Exception", e);
			return false;
		} finally {
			s.close();
		}


	}

	private boolean checkNamingPortJBoss4(StepExecutionContext ctx) {
		//check in /opt/jboss/4.2.3-GA/server/${server.name}/deploy/jboss-web.deployer/server.xml
		HostSession s = server.connectToAdminHost();
		try {
			String fileSep = server.getHost().getFileSeparator();
			HostFile configuration = s.getFile(server.getDeployDirPath() + fileSep + "jboss-web.deployer" + fileSep + "server.xml");
			String nodes = XPathUtils.searchStringWithXPath(configuration, XPATH_JBOSS4);
			if (StringUtils.isBlank(nodes)) {
				ctx.logError(XPATH_JBOSS4 + " gives no candidates");
			} else {
				server.setAjpPort(Integer.parseInt(nodes.trim()));
			}

			return true;
		}
		catch (Exception e) {
			ctx.logError("XML/XPAth Exception", e);
			return false;
		} finally {
			s.close();
		}
	}
}
