/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.jbossas.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.hostsession.CapturingCommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer;
import com.xebialabs.deployit.plugin.jbossas.step.JbossasStepBase;
import java.util.Date;

public class JbossStartStopWaitStep
extends JbossasStepBase {
    public static String JBOSS_SERVER_START_ACTION = "start action";
    public static String JBOSS_SERVER_STOP_ACTION = "stop action";
    private String actionType;
    private int MAX_WAIT_TIME = 480000;
    private int CHECK_INTERVAL = 3000;

    protected JbossStartStopWaitStep(JbossasServer server, String action) {
        super(server);
        this.actionType = action;
    }

    public boolean execute(StepExecutionContext ctx) {
        boolean actionCompletedSuccessfully = false;
        long actionStartTime = new Date().getTime();
        long actionEndTime = new Date().getTime();
        actionCompletedSuccessfully = this.getServerStatus(this.actionType);
        while (!this.timeExpired(actionStartTime, actionEndTime)) {
            this.waitForServerActionCompletion(ctx, actionStartTime, actionEndTime);
            actionEndTime = new Date().getTime();
            actionCompletedSuccessfully = this.getServerStatus(this.actionType);
            if (!actionCompletedSuccessfully) continue;
            ctx.logError("server's " + this.actionType + " completed in " + (actionEndTime - actionStartTime) + " millesecs\n");
            return true;
        }
        ctx.logError("Maximum wait time for server's " + this.actionType + " expired!\n");
        return false;
    }

    private void waitForServerActionCompletion(StepExecutionContext ctx, long actionStartTime, long actionEndTime) {
        ctx.logOutput("Waiting " + this.CHECK_INTERVAL / 1000 + "secs for server's " + this.actionType + " to complete, time elased:" + (actionEndTime - actionStartTime) / 1000L + " secs\n");
        try {
            Thread.sleep(this.CHECK_INTERVAL);
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
    }

    private boolean timeExpired(long actionStartTime, long actionEndTime) {
        return actionEndTime - actionStartTime > (long)this.MAX_WAIT_TIME;
    }

    private boolean getServerStatus(String serverAction) {
        if (serverAction == JBOSS_SERVER_START_ACTION) {
            return this.checkIfServerStarted();
        }
        if (serverAction == JBOSS_SERVER_STOP_ACTION) {
            return this.checkIfServerStopped();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkIfServerStarted() {
        HostSession s = this.server.getHost().getHostSession();
        CapturingCommandExecutionCallbackHandler capturedOutput = new CapturingCommandExecutionCallbackHandler();
        try {
            s.execute((CommandExecutionCallbackHandler)capturedOutput, new String[]{this.getTwiddleFilePath(), "-s", this.server.getHost().getAddress(), "get", "jboss.system:type=Server", "Started"});
            String output = capturedOutput.getOutput();
            if (output.contains("Started=true")) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            s.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkIfServerStopped() {
        HostSession s = this.server.getHost().getHostSession();
        try {
            CapturingCommandExecutionCallbackHandler capturedOutput = new CapturingCommandExecutionCallbackHandler();
            s.execute((CommandExecutionCallbackHandler)capturedOutput, new String[]{this.getTwiddleFilePath(), "-s", this.server.getHost().getAddress(), "query", "jboss.system:type=Server"});
            String output = capturedOutput.getAll();
            if (output.contains("Connection refused")) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            s.close();
        }
    }

    private String getTwiddleFilePath() {
        Host jbossHost = this.server.getHost();
        String fileSep = jbossHost.getFileSeparator();
        return this.server.getHome() + fileSep + "bin" + fileSep + "twiddle" + jbossHost.getScriptExtension();
    }
}

