/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.jbossas.step;

import java.util.Date;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.hostsession.CapturingCommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer;

@SuppressWarnings("serial")
public class JbossStartStopWaitStep extends JbossasStepBase {

	public static String JBOSS_SERVER_START_ACTION = "start action";
	public static String JBOSS_SERVER_STOP_ACTION = "stop action";
	private String actionType;
	private int MAX_WAIT_TIME = 8 * 60 * 1000;
	private int CHECK_INTERVAL = 3 * 1000;

	protected JbossStartStopWaitStep(JbossasServer server, String action) {
		super(server);
		this.actionType = action;
	}

	public boolean execute(StepExecutionContext ctx) {
		boolean actionCompletedSuccessfully = false;
		long actionStartTime = new Date().getTime();
		long actionEndTime = new Date().getTime();
		actionCompletedSuccessfully = getServerStatus(actionType);
		while (!timeExpired(actionStartTime, actionEndTime)) {
			waitForServerActionCompletion(ctx, actionStartTime, actionEndTime);
			actionEndTime = new Date().getTime();
			actionCompletedSuccessfully = getServerStatus(actionType);
			if (actionCompletedSuccessfully) {
				ctx.logError("server's " + actionType + " completed in " + (actionEndTime - actionStartTime) + " millesecs\n");
				return true;
			}
		}
		ctx.logError("Maximum wait time for server's " + actionType + " expired!\n");
		return false;
	}

	private void waitForServerActionCompletion(StepExecutionContext ctx, long actionStartTime, long actionEndTime) {
	    ctx.logOutput("Waiting " + CHECK_INTERVAL / 1000 + "secs for server's " + actionType + " to complete, time elased:" + (actionEndTime - actionStartTime)/1000 +" secs\n");
	    try {
	    	Thread.sleep(CHECK_INTERVAL);
	    } catch (InterruptedException ignored) {
	    	Thread.currentThread().interrupt();
	    }
    }

	private boolean timeExpired(long actionStartTime, long actionEndTime) {
		return (actionEndTime - actionStartTime) > MAX_WAIT_TIME;
	}

	private boolean getServerStatus(String serverAction) {
		if (serverAction == JBOSS_SERVER_START_ACTION) {
			return checkIfServerStarted();
		} else if (serverAction == JBOSS_SERVER_STOP_ACTION) {
			return checkIfServerStopped();
		}
		return false;
	}

	private boolean checkIfServerStarted() {
		HostSession s = server.getHost().getHostSession();
		CapturingCommandExecutionCallbackHandler capturedOutput = new CapturingCommandExecutionCallbackHandler();
		try {
			s.execute(capturedOutput, getTwiddleFilePath(), "-s", server.getHost().getAddress(), "get", "jboss.system:type=Server", "Started");
			String output = capturedOutput.getOutput();
			if (output.contains("Started=true")) {
				return true;
			}
			return false;
		} finally {
			s.close();
		}
	}

	private boolean checkIfServerStopped() {
		HostSession s = server.getHost().getHostSession();
		try {
			CapturingCommandExecutionCallbackHandler capturedOutput = new CapturingCommandExecutionCallbackHandler();
			s.execute(capturedOutput, getTwiddleFilePath(), "-s", server.getHost().getAddress(), "query", "jboss.system:type=Server");
			String output = capturedOutput.getAll();
			if (output.contains("Connection refused")) {
				return true;
			}
			return false;
		} finally {
			s.close();
		}
	}

	private String getTwiddleFilePath() {
		Host jbossHost = server.getHost();
		String fileSep = jbossHost.getFileSeparator();
		return server.getHome() + fileSep + "bin" + fileSep + "twiddle" + jbossHost.getScriptExtension();
	}

}
