/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.jbossas.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasVersion;

import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

@SuppressWarnings("serial")
public class CheckJbossasServerVersionStep extends JbossasStepBase {

	public CheckJbossasServerVersionStep(JbossasServer server) {
		super(server);
		setDescription("Check that JBoss server " + server + " is an installation of the expected version, or retrieve it if not set yet");
	}

	public boolean execute(StepExecutionContext ctx) {
		HostSession s = server.connectToAdminHost();
		try {
			HostFile runJar = s.getFile(server.getRunJarFilePath());
			try {
				JarInputStream runJarIn = new JarInputStream(runJar.get());
				try {
					Manifest runJarManifest = runJarIn.getManifest();
					Attributes runJarMainAttribues = runJarManifest.getMainAttributes();
					String implementationVersion = runJarMainAttribues.getValue("Implementation-Version");
					int indexOfDot = implementationVersion.indexOf('.');
					String majorVersion;
					if (indexOfDot < 0) {
						majorVersion = implementationVersion;
					} else {
						majorVersion = implementationVersion.substring(0, indexOfDot);
					}
					if (server.getVersion() == null || JbossasVersion.JBOSSAS_UNKNOWN.equals(server.getVersion())) {
						ctx.logOutput("There is no version set on server " + server + " trying to set it");
						if ("4".equals(majorVersion)) {
							server.setVersion(JbossasVersion.JBOSSAS_40);
							return true;
						} else if ("5".equals(majorVersion)) {
							server.setVersion(JbossasVersion.JBOSSAS_50);
							return true;
						} else if ("6".equals(majorVersion)) {
							server.setVersion(JbossasVersion.JBOSSAS_60);
							return true;
						} else {
							ctx.logError("Failed to retrieve version of JBoss server " + server+" found "+majorVersion);
							return false;
						}
					}
					switch (server.getVersion()) {
						case JBOSSAS_40:
							if (!("4".equals(majorVersion))) {
								ctx.logError("JBoss server " + server + " is an installation of version " + implementationVersion
										+ " instead of the expected version 4.x");
								return false;
							}
							break;
						case JBOSSAS_50:
							if (!("5".equals(majorVersion))) {
								ctx.logError("JBoss sevrer " + server + " is an installation of version " + implementationVersion
										+ " instead of the expected version 5.x");
								return false;
							}
							break;
					}
					return true;
				} finally {
					runJarIn.close();
				}
			} catch (IOException exc) {
				throw new RuntimeIOException("Cannot read META-INF/MANIFEST from " + server.getRunJarFilePath(), exc);
			}
		} finally {
			s.close();
		}
	}
}
