package com.xebialabs.deployit.plugin.jbossas.step;

import com.xebialabs.deployit.ci.artifact.Ear;
import com.xebialabs.deployit.ci.artifact.EjbJar;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer;

@SuppressWarnings("serial")
public abstract class JbossasDeploymentStepBase extends JbossasStepBase {

	protected NamedDeployableArtifact artifact;

	protected JbossasDeploymentStepBase(JbossasServer server, NamedDeployableArtifact artifact) {
		super(server);
		this.artifact = artifact;
	}

	protected HostFile getArtifactTargetFile(HostSession session) {
		HostFile deployDir = session.getFile(server.getDeployDirPath());

		String targetFileName = artifact.getName();
		if (artifact instanceof Ear) {
			targetFileName += ".ear";
		} else if (artifact instanceof War) {
			targetFileName += ".war";
		} else if (artifact instanceof EjbJar) {
			targetFileName += ".jar";
		} else {
			throw new IllegalArgumentException("Artifact " + artifact + " is neither an EAR, a WAR nor an EJB JAR");
		}

		HostFile targetFile = session.getFile(deployDir, targetFileName);
		return targetFile;
	}

}
