package com.xebialabs.deployit.plugin.jbossas.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.artifact.Ear;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.hostsession.HostSessionFactory;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer;

/**
 * Deploys a {@link com.xebialabs.deployit.ci.artifact.Ear} or a {@link com.xebialabs.deployit.ci.artifact.War} to a {@link com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer}
 */
@SuppressWarnings("serial")
public class JbossasDeployApplicationStep extends JbossasDeploymentStepBase {

	public JbossasDeployApplicationStep(JbossasServer server, Ear ear) {
		super(server, ear);
		setDescription("Deploy EAR file " + ear + " to JBoss server " + server);
	}

	public JbossasDeployApplicationStep(JbossasServer server, War war) {
		super(server, war);
		setDescription("Deploy WAR file " + war + " to JBoss server " + server);
	}

	public boolean execute(StepExecutionContext ctx) {
		HostSession s = server.connectToAdminHost();
		try {
			HostFile targetFile = getArtifactTargetFile(s);

			HostSession ls = HostSessionFactory.getHostSession(Host.getLocalHost());
			try {
				HostFile sourceFile = ls.getFile(artifact.getLocation());

				ctx.logOutput("Copying application artifact to " + targetFile.getPath() + " on " + server.getHost());
				HostFileUtils.copyFile(sourceFile, targetFile);

				ctx.logOutput("Done.");
				return true;
			} finally {
				ls.close();
			}
		} finally {
			s.close();
		}
	}

}
