package com.xebialabs.deployit.plugin.jbossas.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasTopic;

/**
 * Destroys a {@link com.xebialabs.deployit.plugin.jbossas.ci.JbossasTopic} on a {@link com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer}
 */
@SuppressWarnings("serial")
public class DestroyJbossasTopicStep extends JbossasStepBase {

	private JbossasTopic topic;

	public DestroyJbossasTopicStep(JbossasServer server, JbossasTopic topic) {
		super(server);
		this.topic = topic;
		setDescription("Destroy topic " + topic + " on JBoss server " + server);
	}

	public boolean execute(StepExecutionContext ctx) {
		HostSession s = server.connectToAdminHost();
		try {
			HostFile deployDir = s.getFile(server.getDeployDirPath());
			HostFile topicServiceFile = s.getFile(deployDir, topic.getFilename());

			ctx.logOutput("Removing topic configuration from " + topicServiceFile.getPath() + " on " + server.getHost());
			topicServiceFile.delete();

			ctx.logOutput("Done.");
			return true;
		} finally {
			s.close();
		}

	}

}
