package com.xebialabs.deployit.plugin.jbossas.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasQueue;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer;

/**
 * Destroys a {@link com.xebialabs.deployit.plugin.jbossas.ci.JbossasQueue} on a {@link com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer}
 */
@SuppressWarnings("serial")
public class DestroyJbossasQueueStep extends JbossasStepBase {

	private JbossasQueue queue;

	public DestroyJbossasQueueStep(JbossasServer server, JbossasQueue queue) {
		super(server);
		this.queue = queue;
		setDescription("Destroy queue " + queue + " on JBoss server " + server);
	}

	public boolean execute(StepExecutionContext ctx) {
		HostSession s = server.connectToAdminHost();
		try {
			HostFile deployDir = s.getFile(server.getDeployDirPath());
			HostFile queueServiceFile = s.getFile(deployDir, queue.getFilename());

			ctx.logOutput("Removing queue configuration from " + queueServiceFile.getPath() + " on " + server.getHost());
			queueServiceFile.delete();

			ctx.logOutput("Done.");
			return true;
		} finally {
			s.close();
		}
	}

}
