package com.xebialabs.deployit.plugin.jbossas.step;

import org.apache.velocity.VelocityContext;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasDataSource;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer;
import com.xebialabs.deployit.plugin.jbossas.support.VelocityUtils;

/**
 * Creates a {@link com.xebialabs.deployit.plugin.jbossas.ci.JbossasDataSource} on a {@link com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer}
 */
@SuppressWarnings("serial")
public class CreateJbossasDataSourceStep extends JbossasStepBase {

	private JbossasDataSource dataSource;

	public CreateJbossasDataSourceStep(JbossasServer server, JbossasDataSource dataSource) {
		super(server);
		this.dataSource = dataSource;
		setDescription("Create datasource " + dataSource + " on JBoss server " + server);
	}

	public boolean execute(StepExecutionContext ctx) {
		VelocityContext context = new VelocityContext();
		context.put("datasource", dataSource);
		String evaluatedTemplate = VelocityUtils.evaluateTemplate(context, STEP_RESOURCES_PATH + "template-ds.xml.vm");

		HostSession s = server.connectToAdminHost();
		try {
			HostFile deployDir = s.getFile(server.getDeployDirPath());
			HostFile dsFile = s.getFile(deployDir, dataSource.getFilename());

			ctx.logOutput("Copying datasource configuration to " + dsFile.getPath() + " on " + server.getHost());
			HostFileUtils.putStringToHostFile(evaluatedTemplate, dsFile);

			ctx.logOutput("Done.");
			return true;
		} finally {
			s.close();
		}
	}

}
