/**
 * <h2>The <a href="http://www.xebialabs.com/deployit-automated-deployment-java-applications">Deployit</a> plugin for JBoss Application Server.</h2>
 * 
 * This is the standard Deployit plugin for functionality related to JBoss Application Server
 * (further referenced in this documentation as JBoss). It provides support 
 * for JBoss-specific components and allows users to deploy applications containing 
 * JBoss resources to a JBoss Application Server environment.
 * 
 * <h3>Supported middleware</h3>
 * 
 * This plugin supports JBoss Application Server versions 4.2.x.
 * 
 * <h3>Requirements</h3>
 * 
 * The plugin executes its deployment and configuration tasks by connecting to the
 * target host systems and executing <a href="http://www.jboss.org/community/wiki/Twiddle">twiddle</a> 
 * commands there. This implies that the following must be possible:
 * 
 * <ul>
 * <li>creating a connection to the host on which the "deployment manager" is running, 
 * using the {@link com.xebialabs.deployit.ci.Host Host's} specified connection methods
 * <li>starting <code><em>jboss-installation-dir</em>/bin/twiddle.sh</code> ({@code twiddle.bat} on Windows) on the target host server 
 * under the user Deployit uses to connect to the host (or the SUDO user, if specified)
 * </ul>
 * 
 * Further, the following configuration settings must be applied to the JBoss AS instances
 * being managed:
 * 
 * <ul>
 * <li>the {@code DeleteWorkDirOnContextDestroy} attribute in <code><em>server-profile</em>/deploy/jboss-web.deployer/META-INF/jboss-service.xml</code>
 * must be set to {@code true}</li>
 * <li>the {@code ScanEnabled} attribute in <code><em>server-profile</em>/conf/jboss-service.xml</code>
 * must be set to {@code false}</li>
 * </ul>
 * 
 * <h3>Components</h3>
 * 
 * JBoss middleware environments are modeled on the basis of the following Configuration
 * Items (CIs):
 * 
 * <ul>
 * <li>{@link com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer JBoss Application Server}
 * </ul>
 * 
 * Further, the plugin provides CIs for the following JBoss-related resources:
 * 
 * <ul>
 * <li>{@link com.xebialabs.deployit.plugin.jbossas.ci.JbossasDataSource JDBC DataSource}
 * <li>{@link com.xebialabs.deployit.plugin.jbossas.ci.JbossasQueue JMS Queue}
 * <li>{@link com.xebialabs.deployit.plugin.jbossas.ci.JbossasTopic JMS Topic}
 * </ul>
 * 
 * <h3>Supported scenarios</h3>
 * 
 * The plugin supports:
 * 
 * <ul>
 * <li>the initial deployment, re- and undeployment of deployment packages to/from JBoss environments
 * via the {@link com.xebialabs.deployit.plugin.jbossas.runbook.JbossasDeploymentRunBook JBoss Deployment RunBook}
 * </ul>
 * 
 * For details of the exact components supported, sequence in which steps are carried out, limitations
 * etc. please consult the documentation of the appropriate run book.
 * 
 * <h4>Mapping</h4>
 * 
 * The plugin contains the following {@link com.xebialabs.deployit.ci.artifact.DeployableArtifact} mappings: 
 * 
 * <ul>
 * <li>{@link com.xebialabs.deployit.ci.mapping.Mapping} maps an {@link com.xebialabs.deployit.ci.artifact.Ear} to 
 * a {@link com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer JBoss Application Server}
 * <li>{@link com.xebialabs.deployit.ci.mapping.Mapping} maps an {@link com.xebialabs.deployit.ci.artifact.War} to 
 * a {@link com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer JBoss Application Server}
 * </ul>
 * 
 * <p>
 * All JBoss-related resources can be mapped wit the {@link com.xebialabs.deployit.plugin.jbossas.ci.JbossasResourceMapping} to:
 * 
 * <ul>
 * <li>A specified {@link com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer JBoss Application Server} running on a {@link com.xebialabs.deployit.ci.Host}
 * </ul>
 * 
 * <h3>Known limitations</h3>
 * 
 * The plugin does not currently support
 * 
 * <ul>
 * <li>Installation, maintenance or removal of JBoss installations and profiles.
 * <li>Management of JBoss Clusters.
 * </ul>
 * 
 * If you have questions, comments or feedback please <a href="mailto:deployit-dev@xebialabs.com">contact</a>
 * the JBoss development team at XebiaLabs.
 * 
 * @version 1.2
 */
package com.xebialabs.deployit.plugin.jbossas;