package com.xebialabs.deployit.plugin.jbossas.mapper;

import java.util.List;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.mapper.MappingAgnosticStepGeneratingMapper;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasTopic;
import com.xebialabs.deployit.plugin.jbossas.step.CreateJbossasTopicStep;
import com.xebialabs.deployit.plugin.jbossas.step.DestroyJbossasTopicStep;

public class JbossasTopicToJbossasServerMapper extends MappingAgnosticStepGeneratingMapper<JbossasTopic, JbossasServer> {

	public JbossasTopicToJbossasServerMapper(Change<Deployment> change) {
		super(change);
	}

	@Override
	protected void generateAdditionStepsForAddedMapping(JbossasTopic newSource, JbossasServer newTarget, List<Step> steps) {
		steps.add(new CreateJbossasTopicStep(newTarget, newSource));
	}

	@Override
	protected void generateDeletionStepsForDeletedMapping(JbossasTopic oldSource, JbossasServer oldTarget, List<Step> steps) {
		steps.add(new DestroyJbossasTopicStep(oldTarget, oldSource));
	}

}
