package com.xebialabs.deployit.plugin.jbossas.mapper;

import java.util.List;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.mapper.MappingAgnosticStepGeneratingMapper;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasQueue;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer;
import com.xebialabs.deployit.plugin.jbossas.step.CreateJbossasQueueStep;
import com.xebialabs.deployit.plugin.jbossas.step.DestroyJbossasQueueStep;

public class JbossasQueueToJbossasServerMapper extends MappingAgnosticStepGeneratingMapper<JbossasQueue, JbossasServer> {

	public JbossasQueueToJbossasServerMapper(Change<Deployment> change) {
		super(change);
	}

	@Override
	protected void generateAdditionStepsForAddedMapping(JbossasQueue newSource, JbossasServer newTarget, List<Step> steps) {
		steps.add(new CreateJbossasQueueStep(newTarget, newSource));
	}

	@Override
	protected void generateDeletionStepsForDeletedMapping(JbossasQueue oldSource, JbossasServer oldTarget, List<Step> steps) {
		steps.add(new DestroyJbossasQueueStep(oldTarget, oldSource));
	}

}
