package com.xebialabs.deployit.plugin.jbossas.mapper;

import java.util.List;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.mapper.MappingAgnosticStepGeneratingMapper;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasDataSource;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer;
import com.xebialabs.deployit.plugin.jbossas.step.CreateJbossasDataSourceStep;
import com.xebialabs.deployit.plugin.jbossas.step.DestroyJbossasDataSourceStep;

public class JbossasDataSourceToJbossasServerMapper extends MappingAgnosticStepGeneratingMapper<JbossasDataSource, JbossasServer> {

	public JbossasDataSourceToJbossasServerMapper(Change<Deployment> change) {
		super(change);
	}

	@Override
	protected void generateAdditionStepsForAddedMapping(JbossasDataSource newSource, JbossasServer newTarget, List<Step> steps) {
		steps.add(new CreateJbossasDataSourceStep(newTarget, newSource));
	}

	@Override
	protected void generateDeletionStepsForDeletedMapping(JbossasDataSource oldSource, JbossasServer oldTarget, List<Step> steps) {
		steps.add(new DestroyJbossasDataSourceStep(oldTarget, oldSource));
	}

}
