package com.xebialabs.deployit.plugin.jbossas.mapper;

import java.util.List;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.artifact.Ear;
import com.xebialabs.deployit.mapper.MappingAgnosticStepGeneratingMapper;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer;
import com.xebialabs.deployit.plugin.jbossas.step.JbossasDeployApplicationStep;
import com.xebialabs.deployit.plugin.jbossas.step.JbossasUndeployApplicationStep;

public class EarToJbossasServerMapper extends MappingAgnosticStepGeneratingMapper<Ear, JbossasServer> {

	public EarToJbossasServerMapper(Change<Deployment> change) {
		super(change);
	}

	@Override
	protected void generateAdditionStepsForAddedMapping(Ear newSource, JbossasServer newTarget, List<Step> steps) {
		steps.add(new JbossasDeployApplicationStep(newTarget, newSource));
	}

	@Override
	protected void generateDeletionStepsForDeletedMapping(Ear oldSource, JbossasServer oldTarget, List<Step> steps) {
		steps.add(new JbossasUndeployApplicationStep(oldTarget, oldSource));
	}

}
