package com.xebialabs.deployit.plugin.jbossas.ci;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ConfigurationItemProperty.Size;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.artifact.mapping.EarMapping;
import com.xebialabs.deployit.hostsession.HostSession;

/**
 * A JBoss Application Server
 */
@SuppressWarnings("serial")
@ConfigurationItem(description = "JBoss Application Server instance", targetForMappingTypes = { EarMapping.class })
public class JbossasServer extends BaseConfigurationItem {

	@ConfigurationItemProperty(required = true, label = "JBoss server host", description = "The host on which the JBoss server is running")
	private Host host;

	@ConfigurationItemProperty(required = true, label = "JBoss installation location", description = "The place where JBoss is installed such as /usr/local/jboss-5.1.0.GA", size = Size.LARGE)
	private String home;

	@ConfigurationItemProperty(required = true, label = "JBoss instance name", description = "The name of the JBoss server instance, e.g. default or minimal")
	private String name;

	public String getCommandFilePath(String command) {
		String fileSep = getHost().getFileSeparator();
		return getHome() + fileSep + "bin" + fileSep + command + getHost().getScriptExtension();
	}

	public String getTwiddleFilePath() {
		return getCommandFilePath("twiddle");
	}

	public String getShutdownFilePath() {
		return getCommandFilePath("shutdown");
	}

	public String getDeployDirPath() {
		String fileSep = getHost().getFileSeparator();
		return getHome() + fileSep + "server" + fileSep + getName() + fileSep + "deploy";
	}

	public HostSession connectToAdminHost() {
		return getHost().getHostSession();
	}

	public Host getHost() {
		return host;
	}

	public void setHost(Host host) {
		this.host = host;
	}

	public String getHome() {
		return home;
	}

	public void setHome(String home) {
		this.home = home;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

}
