package com.xebialabs.deployit.plugin.jbossas.ci;

import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ConfigurationItemProperty.Size;

/**
 * A JBoss JDBC DataSource
 */
@SuppressWarnings("serial")
@ConfigurationItem
public class JbossasDataSource extends JbossasResource {

	@ConfigurationItemProperty
	private String driverClass;

	@ConfigurationItemProperty(size = Size.LARGE)
	private String connectionUrl;

	@ConfigurationItemProperty
	private String username;

	@ConfigurationItemProperty(password = true)
	private String password;

	@ConfigurationItemProperty
	private int minPoolSize;

	@ConfigurationItemProperty
	private int maxPoolSize;

	@ConfigurationItemProperty
	private boolean useJavaContext;

	public String getDriverClass() {
		return driverClass;
	}

	public void setDriverClass(String driverClass) {
		this.driverClass = driverClass;
	}

	public String getConnectionUrl() {
		return connectionUrl;
	}

	public void setConnectionUrl(String connectionUrl) {
		this.connectionUrl = connectionUrl;
	}

	public String getUsername() {
		return username;
	}

	public void setUsername(String username) {
		this.username = username;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public int getMinPoolSize() {
		return minPoolSize;
	}

	public void setMinPoolSize(int minPoolSize) {
		this.minPoolSize = minPoolSize;
	}

	public int getMaxPoolSize() {
		return maxPoolSize;
	}

	public void setMaxPoolSize(int maxPoolSize) {
		this.maxPoolSize = maxPoolSize;
	}

	public void setUseJavaContext(boolean useJavaContext) {
		this.useJavaContext = useJavaContext;
	}

	public boolean isUseJavaContext() {
		return useJavaContext;
	}

}
