/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.jbossas.step;

import com.xebialabs.deployit.ci.artifact.Ear;
import com.xebialabs.deployit.ci.artifact.EjbJar;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer;
import com.xebialabs.deployit.plugin.jbossas.step.JbossasStepBase;

public abstract class JbossasDeploymentStepBase
extends JbossasStepBase {
    protected NamedDeployableArtifact artifact;

    protected JbossasDeploymentStepBase(JbossasServer server, NamedDeployableArtifact artifact) {
        super(server);
        this.artifact = artifact;
    }

    protected HostFile getArtifactTargetFile(HostSession session) {
        HostFile deployDir = session.getFile(this.server.getDeployDirPath());
        String targetFileName = this.artifact.getName();
        if (this.artifact instanceof Ear) {
            targetFileName = targetFileName + ".ear";
        } else if (this.artifact instanceof War) {
            targetFileName = targetFileName + ".war";
        } else if (this.artifact instanceof EjbJar) {
            targetFileName = targetFileName + ".jar";
        } else {
            throw new IllegalArgumentException("Artifact " + this.artifact + " is neither an EAR, a WAR nor an EJB JAR");
        }
        HostFile targetFile = session.getFile(deployDir, targetFileName);
        return targetFile;
    }
}

