/*
 * Copyright (c) 2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of Xebialabs Software and Documentation is subject to the Personal
 * License Agreement.
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * ‚ÄúDocumentation‚Äù means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the Xebialabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to  (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.jbossas.step;

import com.xebialabs.deployit.ci.artifact.Ear;
import com.xebialabs.deployit.ci.artifact.EjbJar;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasServer;

@SuppressWarnings("serial")
public abstract class JbossasDeploymentStepBase extends JbossasStepBase {

	protected NamedDeployableArtifact artifact;

	protected JbossasDeploymentStepBase(JbossasServer server, NamedDeployableArtifact artifact) {
		super(server);
		this.artifact = artifact;
	}

	protected HostFile getArtifactTargetFile(HostSession session) {
		HostFile deployDir = session.getFile(server.getDeployDirPath());

		String targetFileName = artifact.getName();
		if (artifact instanceof Ear) {
			targetFileName += ".ear";
		} else if (artifact instanceof War) {
			targetFileName += ".war";
		} else if (artifact instanceof EjbJar) {
			targetFileName += ".jar";
		} else {
			throw new IllegalArgumentException("Artifact " + artifact + " is neither an EAR, a WAR nor an EJB JAR");
		}

		HostFile targetFile = session.getFile(deployDir, targetFileName);
		return targetFile;
	}

}
