/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.platform.test.testng;

import com.xebialabs.platform.test.testng.RuleBase;
import com.xebialabs.platform.test.testng.TestNGRule;
import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicBoolean;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.ITestClass;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.TestNGException;

public class RuleListener
implements IInvokedMethodListener {
    private AtomicBoolean initialized = new AtomicBoolean(false);

    public void beforeInvocation(IInvokedMethod method, ITestResult testResult) {
        if (this.shouldStart(method) && !this.initialized.getAndSet(true)) {
            this.findAndStartRule(method);
        }
    }

    public void afterInvocation(IInvokedMethod method, ITestResult testResult) {
        if (this.shouldStop(method) && this.initialized.getAndSet(false)) {
            this.findAndStopRule(method);
        }
    }

    private boolean shouldStart(IInvokedMethod method) {
        return method.isTestMethod() || method.getTestMethod().isBeforeMethodConfiguration();
    }

    private boolean shouldStop(IInvokedMethod method) {
        ITestClass testClass = method.getTestMethod().getTestClass();
        if (testClass.getAfterTestMethods().length == 0 && method.isTestMethod()) {
            return true;
        }
        if (testClass.getAfterTestMethods().length > 0) {
            ITestNGMethod[] afterTestMethods = testClass.getAfterTestMethods();
            return method.getTestMethod().equals((Object)afterTestMethods[afterTestMethods.length - 1]);
        }
        return false;
    }

    private void findAndStopRule(IInvokedMethod method) {
        RuleBase rule = this.getRule(method);
        if (rule != null) {
            rule.stop();
        }
    }

    private void findAndStartRule(IInvokedMethod method) {
        RuleBase rule = this.getRule(method);
        if (rule != null) {
            rule.start();
        }
    }

    private RuleBase getRule(IInvokedMethod method) {
        Field ruleField = this.findRuleField(method);
        if (ruleField == null) {
            return null;
        }
        try {
            return (RuleBase)ruleField.get(method.getTestMethod().getInstance());
        }
        catch (IllegalAccessException e) {
            throw new TestNGException((Throwable)e);
        }
    }

    private Field findRuleField(IInvokedMethod method) {
        Field[] fields;
        Class realClass = method.getTestMethod().getRealClass();
        for (Field field : fields = realClass.getFields()) {
            if (!field.isAnnotationPresent(TestNGRule.class)) continue;
            return field;
        }
        return null;
    }
}

