package com.xebialabs.platform.test.testng.rules;

import java.io.File;
import java.io.IOException;
import org.junit.rules.TemporaryFolder;
import org.testng.TestNGException;

import com.xebialabs.platform.test.testng.RuleBase;

public class TempDir implements RuleBase {
    private TemporaryFolder folder;

    public TempDir() {
        folder = new TemporaryFolder();
    }

    public void create() throws IOException {
        folder.create();
    }

    public File newFile(String fileName) throws IOException {
        return folder.newFile(fileName);
    }

    public File newFile() throws IOException {
        return folder.newFile();
    }

    public File newFolder(String folder) throws IOException {
        return this.folder.newFolder(folder);
    }

    public File newFolder(String... folderNames) throws IOException {
        return folder.newFolder(folderNames);
    }

    public File newFolder() throws IOException {
        return folder.newFolder();
    }

    public File getRoot() {
        return folder.getRoot();
    }

    public void delete() {
        folder.delete();
    }

    public TempDir(File tempDirParent) {
        folder = new TemporaryFolder(tempDirParent);
    }

    public TemporaryFolder getWrapped() {
        return folder;
    }

    @Override
    public void start() {
        try {
            create();
        } catch (IOException e) {
            throw new TestNGException(e);
        }
    }

    @Override
    public void stop() {
        delete();
    }
}
